# PySNMP SMI module. Autogenerated from smidump -f python APPC-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:40 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( snanauMIB, ) = mibBuilder.importSymbols("SNA-NAU-MIB", "snanauMIB")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mib-2")
( DateAndTime, DisplayString, InstancePointer, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "DisplayString", "InstancePointer", "TextualConvention")

# Types

class SnaSenseData(DisplayString):
    subtypeSpec = DisplayString.subtypeSpec+ValueSizeConstraint(8,8)
    fixedLength = 8
    

# Objects

appcMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 34, 3)).setRevisions(("1995-12-15 00:00",))
if mibBuilder.loadTexts: appcMIB.setOrganization("IETF SNA NAU MIB Working Group")
if mibBuilder.loadTexts: appcMIB.setContactInfo("\nMichael Allen\nWall Data Inc.\nP.O.Box 1120\nDuval, WA 98019, USA\nTel:    1 206 844 3505\nE-mail: mallen@hq.walldata.com\n\nBob Clouston\nCisco Systems\n7025 Kit Creek Road\nP.O. Box 14987\nResearch Triangle Park, NC 27709, USA\nTel:    1 919 472 2333\nE-mail: clouston@cisco.com\n\nZbigniew Kielczewski\nCisco Systems\n3100 Smoketree Court\nRaleigh, NC 27604, USA\nTel:    1 919 871 6326\nE-mail: zbig@cisco.com\nWilliam Kwan\nJupiter Technology Inc.\n200 Prospect Street\nWaltham, MA 02254, USA\nTel:    1 617 894 9300, x423\nE-mail: billk@jti.com\n\nBob Moore\nIBM Corporation\n800 Park Offices Drive\nCNMA/664\nP.O. Box 12195\nResearch Triangle Park, NC 27709, USA\nTel:    1 919 254 4436\nE-mail: remoore@ralvm6.vnet.ibm.com")
if mibBuilder.loadTexts: appcMIB.setDescription("This is the MIB module for objects used to manage network\ndevices with APPC capabilities.")
appcObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1))
appcGlobal = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 1))
appcCntrlAdminGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 1))
appcCntrlAdminStat = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCntrlAdminStat.setDescription("Indicates the desired state of statistics collection:\n\nnotActive  collection of counters is not active.\nactive     collection of counters is active.\nWhen this object is set to notActive, all of the entries are\nremoved from the appcSessStatsTable.")
appcCntrlAdminRscv = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCntrlAdminRscv.setDescription("Indicates the desired state of RSCV information collection:\nnotActive  collection of route selection control vectors\n           is not active.\nactive     collection of route selection control vectors\n           is active.")
appcCntrlAdminTrace = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCntrlAdminTrace.setDescription("Indicates the desired state of tracing:\n\nnotActive  collection of tracing information is not active\nactive     collection of tracing information is active")
appcCntrlAdminTraceParm = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCntrlAdminTraceParm.setDescription("Specifies the parameter to be used in conjunction with\nactivating tracing.  The actual content is implementation\ndependent.")
appcCntrlOperGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 2))
appcCntrlOperStat = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 2, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCntrlOperStat.setDescription("Indicates the current collection options in effect:\n\nnotActive  collection of counters is not active.\nactive     collection of counters is active.\n\nStatistical entries are present in the appcSessStatsTable\nonly when the value of this object is 'active'.")
appcCntrlOperStatTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 2, 2), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCntrlOperStatTime.setDescription("Time since the appcCntrlOperStat object last changed.\nThis time is in hundreds of a second.")
appcCntrlOperRscv = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 2, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCntrlOperRscv.setDescription("Indicates the current collection options in effect:\n\nnotActive  collection of route selection control vectors\n           is not active.\nactive     collection of route selection control vectors\n           is active.")
appcCntrlOperRscvTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 2, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCntrlOperRscvTime.setDescription("Time since the appcCntrlOperRscv object last changed.\nThis time is in hundreds of a second.")
appcCntrlOperTrace = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 2, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCntrlOperTrace.setDescription("Indicates the current state of tracing:\n\nnotActive  collection of tracing information is not active.\nactive     collection of tracing information is active.")
appcCntrlOperTraceTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 2, 6), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCntrlOperTraceTime.setDescription("Time since the appcCntrlOperTrace object last changed.\nThis time is in hundreds of a second.")
appcCntrlOperTraceParm = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 2, 7), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCntrlOperTraceParm.setDescription("Specifies the parameter used in conjunction with activating\ntracing. The actual content is implementation dependent.")
appcGlobalObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3))
appcUpTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 1), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcUpTime.setDescription("The time, in hundredths of a second, since the\nAPPC portion of the system was last reinitialized.")
appcDefaultModeName = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcDefaultModeName.setDescription("Specifies the mode name to be used under the following\nconditions:\n\n   When an incoming BIND request contains a mode name not\n   defined at the local node.  The parameters defined for\n   this mode are used for the inbound implicit mode\n   capability.\n\n   When an APPC program issues an [MC_]ALLOCATE,\n   [MC_]SEND_CONVERSATION, or CNOS verb, or when a CPI-C\n   program issues an Allocate (CMALLC) call,\n   specifying a mode name not defined at the local node.  The\n   parameters defined for this mode are used for the outbound\n   implicit mode capability.\n\nThis mode name must match a defined entry in the\nappcModeAdminTable.")
appcDefaultLuName = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcDefaultLuName.setDescription("Specifies the name of the local LU that is to serve as the\ndefault LU.  This is the default LU to which are routed inbound\nBIND requests that exclude the secondary LU name.  This field\nis from 1 to 17 characters in length, including a period (.)\nwhich separates the NetId from the NAU name if the NetId is\npresent.  This local LU name must match a defined entry in the\nappcLluAdminTable.")
appcDefaultImplInbndPlu = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcDefaultImplInbndPlu.setDescription("Specifies whether or not inbound implicit partner LU support\nis enabled.  The following values are defined:\n\n    no   -  Specifies that inbound implicit partner LU support\n            is disabled, which means that an incoming bind that\n            specifies a partner LU that is not defined at the\n            local node will be rejected.\n\n    yes  -  Specifies that inbound implicit partner LU support\n            is enabled, which provides the capability to accept\n            an incoming BIND request that contains a partner LU\n            name that is not defined at the local node.")
appcDefaultMaxMcLlSndSize = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcDefaultMaxMcLlSndSize.setDescription("Specifies the maximum size of a logical record to be used for\na mapped conversation when sending data to either the inbound\nor outbound implicit partner LU.  This size is the maximum\nnumber of bytes in a single logical record, as indicated in the\nLL field of the record.  The default value is 32767.\n\nNote that this object does not limit the maximum size that an\napplication program can supply on the Send Data call for a\nmapped conversation.")
appcDefaultFileSpec = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 6), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 80))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcDefaultFileSpec.setDescription("The local file specification that is to be searched by the\nAPPC attach manager when no DEFINE_TP verb has been issued\nfor the TP name received on an incoming attach.  In this\ncase, the attach manager will attempt to start a program\nwhose file name is the same as the incoming TP name.  If\nfound, the program is loaded. If not found, the attach is\nrejected.\n\nThe value '*' indicates that the normal search path for\nexecutable programs is to be used for locating an undefined\ntransaction program.\n\nA null string indicates that there is no default file\nspecification for undefined transaction programs.")
appcDefaultTpOperation = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(4,3,5,1,2,)).subtype(namedValues=NamedValues(("other", 1), ("queuedOperatorStarted", 2), ("queuedOperatorPreloaded", 3), ("queuedAmStarted", 4), ("nonqueuedAmStarted", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcDefaultTpOperation.setDescription("Specifies how the program will be started.\n\nother - Specifies that the default TP operation is none of\n        the methods specified below. It may be a\n        product-specific method.\n\nqueuedOperatorStarted - Specifies that one version of the\n        program will be run at a time.  If an incoming\n        attach arrives and the program has not been started\n        yet, APPC will issue a message to the operator to\n        start the specified program.  Subsequent attaches\n        that arrive while the program is active will be\n        queued.\n\nqueuedOperatorPreloaded - Specifies that one version\n        of the program will be run at a time.  If an\n        incoming attach arrives and the program has not\n        been started yet, the Attach will be rejected.  The\n        APPC attach manager determines that a TP has\n        started upon reception of an APPC RECEIVE_ALLOCATE\n        verb, or a CPI-C Accept_Conversation (CMACCP) or\n        Specify_Local_TP_Name (CMSLTP) call.  No message is\n        sent to the operator.  Subsequent attaches that\n        arrive while the program is active are queued.\n\nqueuedAmStarted - Specifies that one version of the\n        program will be run at a time and will be started\n        by the APPC attach manager.  Subsequent attaches\n        that arrive while the program is active will be\n        queued.\n\nnonqueuedAmStarted - Specifies that multiple copies of\n        the program will be run at a time and will be\n        started by the APPC attach manager. ")
appcDefaultTpConvSecRqd = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcDefaultTpConvSecRqd.setDescription("Specifies whether or not conversation security will be used\nfor default TPs.\n\n    no   -  Specifies that the incoming attach does not have to\n            contain security information.\n    yes  -  Specifies that the incoming attach must contain\n            valid authentication information (e.g., user ID and\n            password).")
appcLocalCpName = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 9), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLocalCpName.setDescription("Specifies the name of the local control point.  This field is\nfrom 0 to 17 characters in length, including a period (.) which\nseparates the NetId from the NAU name if the NetId is present.\nA null string indicates that the value is unknown.")
appcActiveSessions = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 10), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveSessions.setDescription("Specifies the total number of active APPC sessions supported\nby this implementation.  Sessions for which both LUs are local\nare counted twice.")
appcActiveHprSessions = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 3, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveHprSessions.setDescription("Specifies the total number of active HPR APPC sessions.")
appcCnosControl = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4))
appcCnosCommand = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("initSesslimit", 1), ("changeSesslimit", 2), ("resetSesslimit", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosCommand.setDescription("Specifies the CNOS command or verb to issue.  First set the\nvalues of the particular CNOS parameter objects (from the range\n{ appcCnosControl 2 } through { appcCnosControl 8 }) that apply\nto the CNOS command to be executed, set the three CNOS target\nobjects ({ appcCnosControl 9 } through { appcCnosControl 11 }),\nthen set this object to the command to be executed.\n\nHere is the list of parameter objects that must be set for each\nof the CNOS commands:\n\n   INIT_SESSION_LIMIT -\n      appcCnosMaxSessLimit\n      appcCnosMinCwinLimit\n      appcCnosMinClosLimit\n      appcCnosTargetLocLuName\n      appcCnosTargetParLuName\n      appcCnosTargetModeName\n\n   CHANGE_SESSION_LIMIT -\n      appcCnosMaxSessLimit\n      appcCnosMinCwinLimit\n      appcCnosMinClosLimit\n      appcCnosResponsible\n      appcCnosTargetLocLuName\n      appcCnosTargetParLuName\n      appcCnosTargetModeName\n\n   RESET_SESSION_LIMIT -\n      appcCnosResponsible\n      appcCnosDrainPart\n      appcCnosForce\n      appcCnosTargetLocLuName\n      appcCnosTargetParLuName\n      appcCnosTargetModeName")
appcCnosMaxSessLimit = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 2), Integer32().clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosMaxSessLimit.setDescription("Specifies the maximum value that the local LU is to use,\nduring CNOS processing, for the session limit.  The local LU,\nas a target LU, will negotiate a higher session limit it\nreceives in the CNOS request down to this maximum value.  The\nlocal LU, as a source LU, will restrict the session limit it\nsends in a CNOS request to a value less than or equal to this\nmaximum value.\n\n If set (i.e., greater than 0), this overrides the maximum\n session limit defined in the appcModeAdminTable.\n\n This parameter should be set to the desired value before\n setting the command (appcCnosCommand).\n\n This parameter applies to the INITIALIZE_SESSION_LIMIT and\n CHANGE_SESSION_LIMIT verbs.")
appcCnosMinCwinLimit = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 3), Integer32().clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosMinCwinLimit.setDescription("Specifies the default minimum contention winner sessions\nlimit.\n\nThis parameter should be set to the desired value before\nsetting the command (appcCnosCommand).\n\nThis parameter applies to the INITIALIZE_SESSION_LIMIT and\nCHANGE_SESSION_LIMIT verbs.")
appcCnosMinClosLimit = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 4), Integer32().clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosMinClosLimit.setDescription("Specifies the default minimum contention loser sessions limit.\n\nThis parameter should be set to the desired value before\nsetting the command (appcCnosCommand).\n\nThis parameter applies to the INITIALIZE_SESSION_LIMIT and\nCHANGE_SESSION_LIMIT verbs.")
appcCnosDrainSelf = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosDrainSelf.setDescription("Specifies whether the local LU is draining its conversations\nfor this mode.  When a mode session limit is reset (via a CNOS\nRESET_SESSION_LIMIT request), the local LU could be set to\nprocess all queued conversations before deactivating all of the\nsessions (using the SNA Bracket Initiation Stopped or BIS\nprotocol).\n\nThis parameter should be set to the desired value before\nsetting the command (appcCnosCommand).\n\nThis parameter applies only to the RESET_SESSION_LIMIT verb.")
appcCnosDrainPart = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosDrainPart.setDescription("Specifies whether the partner LU is draining its conversations\nfor this mode.  When a mode session limit is reset (via a CNOS\nRESET_SESSION_LIMIT request), the partner LU could be set to\nprocess all queued conversations before deactivating all of the\nsessions (using the SNA Bracket Initiation Stop or BIS\nprotocol).\n\nThis parameter should be set to the desired value before\nsetting the command (appcCnosCommand).\n\nThis parameter applies only to the RESET_SESSION_LIMIT verb.")
appcCnosResponsible = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("source", 1), ("target", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosResponsible.setDescription("Specifies which LU is responsible for selecting and\ndeactivating sessions as a result of a change that decreases\nthe session limit or the maximum number of contention winner\nsessions for the source or target LU.  If no session need to be\ndeactivated, this parameter is ignored.\n\n      source  -       specifies that the source (local) LU is\n                      responsible.  The target (partner) LU\n                      cannot negotiate this value.\n      target  -       specifies that the target (partner) LU is\n                      responsible. The target LU can negotiate\n                      this value to source.\n\n This parameter should be set to the desired value before\n setting the command (appcCnosCommand).\n\n This parameter applies to the RESET_SESSION_LIMIT and\n CHANGE_SESSION_LIMIT verbs.")
appcCnosForce = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosForce.setDescription("Specifies whether the local LU should force the resetting of\nthe session limit when certain error conditions occur that\nprevent the successful exchange of CNOS request and reply.\n\n This parameter should be set to the desired value before\n setting the command (appcCnosCommand).\n\n This parameter applies only to the RESET_SESSION_LIMIT verb.")
appcCnosTargetLocLuName = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 9), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosTargetLocLuName.setDescription("The SNA name of the local LU to which the CNOS command is\nto be applied. This field is from 1 to 17 characters in\nlength, including a period (.) which separates the\nNetId from the NAU name if the NetId is present.\n\nThis object should be set to the desired value before setting\nthe command (appcCnosCommand).\n\nThis parameter applies to all CNOS verbs.")
appcCnosTargetParLuName = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 10), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosTargetParLuName.setDescription("The SNA name of the partner LU to which the CNOS command is\nto be applied. This field is from 1 to 17 characters in\nlength, including a period (.) which separates the\nNetId from the NAU name if the NetId is present.\n\nThis object should be set to the desired value before setting\nthe command (appcCnosCommand).\n\nThis parameter applies to all CNOS verbs.")
appcCnosTargetModeName = MibScalar((1, 3, 6, 1, 2, 1, 34, 3, 1, 1, 4, 11), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcCnosTargetModeName.setDescription("Specifies the mode name to which the CNOS command is to be\napplied.\n\nThis object should be set to the desired value before setting\nthe command (appcCnosCommand).\n\nThis parameter applies to all CNOS verbs.")
appcLu = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 2))
appcLluAdminTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1))
if mibBuilder.loadTexts: appcLluAdminTable.setDescription("APPC Local LU Admin Table.")
appcLluAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1)).setIndexNames((0, "APPC-MIB", "appcLluAdminName"))
if mibBuilder.loadTexts: appcLluAdminEntry.setDescription("Information about local APPC LUs. ")
appcLluAdminName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcLluAdminName.setDescription("Specifies the name of the local LU.  This field is from 1 to\n17 characters in length, including a period (.) which separates\nthe NetId from the NAU name if the NetId is present.")
appcLluAdminDepType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("dependent", 1), ("independent", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluAdminDepType.setDescription("This value identifies whether the LU is dependent or\nindependent.")
appcLluAdminLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluAdminLocalAddress.setDescription("The local address for this LU is a byte with a value ranging\nfrom 0 to 254.  For dependent LUs, this value ranges from 1 to\n254; for independent LUs this value is always 0.")
appcLluAdminSessLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluAdminSessLimit.setDescription("The maximum number of sessions supported by this LU.")
appcLluAdminBindRspMayQ = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluAdminBindRspMayQ.setDescription("Indicates whether or not the local LU, as the sender of a BIND\nrequest, allows a partner partner LU to delay sending the BIND\nresponse if the partner LU cannot process the BIND request\nimmediately.")
appcLluAdminCompression = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("prohibited", 1), ("required", 2), ("negotiable", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluAdminCompression.setDescription("Specifies whether compression is supported. The local LU uses\nthis value for negotiation during session activation\n(SNA BIND).\n\n   prohibited  -  specifies that no compression is to be used.\n   required    -  specifies that compression is required.\n   negotiable  -  specifies that the usage of compression\n                  is to be negotiated between the LUs. The\n                  level of compression is also negotiated.")
appcLluAdminInBoundCompLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,5,)).subtype(namedValues=NamedValues(("none", 1), ("rle", 2), ("lz9", 3), ("lz10", 4), ("lz12", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluAdminInBoundCompLevel.setDescription("Specifies the maximum level of compression supported for\ninbound data.  The local LU uses this value in conjunction with\nappcLluAdminCompression for negotiation during session\nactivation (SNA BIND).\n    none  -  specifies that no compression is to be used.\n    rle   -  specifies run-length encoding compression\n             in which a 1 or 2 byte sequence substitution is\n             used for each repeated run of the same character.\n    lz9   -  specifies Lempel-Ziv-like compression in which\n             9 bit codes are used to substitute repeated\n             substrings in the data stream.  These codes are\n             indices that refer to entries in a common\n             dictionary generated adaptively at both sender and\n             receiver as the data flows and compression occurs.\n             The larger number bits used for the code, the more\n             storage space is required for the dictionary, but\n             the larger the compression ratio.\n    lz10  -  specifies a 10 bit code Lempel-Ziv-like compression.\n    lz12  -  specifies a 12 bit code Lempel-Ziv-like compression.")
appcLluAdminOutBoundCompLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,5,)).subtype(namedValues=NamedValues(("none", 1), ("rle", 2), ("lz9", 3), ("lz10", 4), ("lz12", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluAdminOutBoundCompLevel.setDescription("Specifies the maximum level of compression supported for\noutbound data.  The local LU uses this value in conjunction\nwith appcLluAdminCompression for negotiation during session\nactivation (SNA BIND).\n    none  -  specifies that no compression is to be used.\n    rle   -  specifies run-length encoding compression\n             in which a 1 or 2 byte sequence substitution is\n             used for each repeated run of the same character.\n    lz9   -  specifies Lempel-Ziv-like compression in which\n             9 bit codes are used to substitute repeated\n             substrings in the data stream.  These codes are\n             indices that refer to entries in a common\n             dictionary generated adaptively at both sender and\n             receiver as the data flows and compression occurs.\n             The larger of number bits used for the code, the\n             more storage space is required for the dictionary,\n             but the larger the compression ratio.\n    lz10  -  specifies a 10 bit code Lempel-Ziv-like compression.\n    lz12  -  specifies a 12 bit code Lempel-Ziv-like compression.")
appcLluAdminCompRleBeforeLZ = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluAdminCompRleBeforeLZ.setDescription("Specifies whether run-length encoding is to be applied to the\ndata before applying Lempel-Ziv-like compression.  The local LU\nuses this value for negotiation during session activation (SNA\nBIND).  This parameter is only supported if LZ compression is\nused.")
appcLluAdminAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 1, 1, 10), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluAdminAlias.setDescription("A local alias for the local LU.  If not known or\nnot applicable, this object contains a zero-length\nstring.")
appcLluOperTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2))
if mibBuilder.loadTexts: appcLluOperTable.setDescription("APPC Local LU Operational Table.")
appcLluOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1)).setIndexNames((0, "APPC-MIB", "appcLluOperName"))
if mibBuilder.loadTexts: appcLluOperEntry.setDescription("Information about local APPC LUs.")
appcLluOperName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcLluOperName.setDescription("Specifies the name of the local LU.  This field is from 1 to\n17 characters in length, including a period (.) which separates\nthe NetId from the NAU name if the NetId is present.")
appcLluOperDepType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("dependent", 1), ("independent", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperDepType.setDescription("This value identifies whether the LU is dependent or\nindependent.")
appcLluOperLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperLocalAddress.setDescription("The local address for this LU is a byte with a value ranging\nfrom 0 to 254.  For dependent LUs, this value ranges from 1 to\n254; for independent LUs this value is always 0.")
appcLluOperSessLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperSessLimit.setDescription("The maximum number of sessions supported by this LU.")
appcLluOperBindRspMayQ = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperBindRspMayQ.setDescription("Indicates whether or not the local LU, as the sender of a BIND\nrequest, allows a partner LU to delay sending the BIND\nresponse if the partner LU cannot process the BIND request\nimmediately.")
appcLluOperCompression = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("prohibited", 1), ("required", 2), ("negotiable", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperCompression.setDescription("Specifies whether compression is supported.  The local LU uses\nthis value for negotiation during session activation (SNA\nBIND).\n\n    prohibited  -  specifies that no compression is to be used.\n    required    -  specifies that compression is required.\n    negotiable  -  specifies that the usage of compression\n                   is to be negotiated between the LUs. The\n                   level of compression is also negotiated.")
appcLluOperInBoundCompLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,5,)).subtype(namedValues=NamedValues(("none", 1), ("rle", 2), ("lz9", 3), ("lz10", 4), ("lz12", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperInBoundCompLevel.setDescription("Specifies the maximum level of compression supported for\ninbound data.  The local LU uses this value in conjunction with\nappcLluOperCompression for negotiation during session\nactivation (SNA BIND).\n\n    none  -  specifies that no compression is to be used.\n    rle   -  specifies run-length encoding compression\n             in which a 1 or 2 byte sequence substitution is\n             used for each repeated run of the same character.\n    lz9   -  specifies Lempel-Ziv-like compression in which\n             9 bit codes are used to substitute repeated\n             substrings in the data stream.  These codes are\n             indices that refer to entries in a common\n             dictionary generated adaptively at both sender and\n             receiver as the data flows and compression occurs.\n             The larger of number bits used for the code, the\n             more storage space is required for the dictionary,\n             but the larger the compression ratio.\n    lz10  -  specifies a 10 bit code Lempel-Ziv-like compression.\n    lz12  -  specifies a 12 bit code Lempel-Ziv-like compression.")
appcLluOperOutBoundCompLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,5,)).subtype(namedValues=NamedValues(("none", 1), ("rle", 2), ("lz9", 3), ("lz10", 4), ("lz12", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperOutBoundCompLevel.setDescription("Specifies the maximum level of compression supported for\noutbound data.  The local LU uses this value in conjunction\nwith appcLluAdminCompression for negotiation during session\nactivation (SNA BIND).\n\n    none  -  specifies that no compression is to be used.\n    rle   -  specifies run-length encoding compression\n             in which a 1 or 2 byte sequence substitution is\n             used for each repeated run of the same character.\n    lz9   -  specifies Lempel-Ziv-like compression in which\n             9 bit codes are used to substitute repeated\n             substrings in the data stream.  These codes are\n             indices that refer to entries in a common\n             dictionary generated adaptively at both sender and\n             receiver as the data flows and compression occurs.\n             The larger of number bits used for the code, the\n             more storage space is required for the dictionary,\n             but the larger the compression ratio.\n    lz10  -  specifies a 10 bit code Lempel-Ziv-like compression.\n    lz12  -  specifies a 12 bit code Lempel-Ziv-like compression.")
appcLluOperCompRleBeforeLZ = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperCompRleBeforeLZ.setDescription("Specifies whether run-length encoding is to be applied to the\ndata before applying Lempel-Ziv-like compression.  The local LU\nuses this value for negotiation during session activation (SNA\nBIND).  This parameter is only supported if LZ compression is\nused.")
appcLluOperAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 10), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperAlias.setDescription("A local alias for the local LU.  If not known or\nnot applicable, this object contains a zero-length\nstring.")
appcLluOperActiveSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 2, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLluOperActiveSessions.setDescription("Specifies the total number of active APPC sessions for this\nLU.")
appcLuPairAdminTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3))
if mibBuilder.loadTexts: appcLuPairAdminTable.setDescription("APPC Partner LU administrative Table")
appcLuPairAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3, 1)).setIndexNames((0, "APPC-MIB", "appcLuPairAdminLocLuName"), (0, "APPC-MIB", "appcLuPairAdminParLuName"))
if mibBuilder.loadTexts: appcLuPairAdminEntry.setDescription("Entry of APPC Partner LU Information Table.\nIt is indexed by the local and partner LU Names.")
appcLuPairAdminLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcLuPairAdminLocLuName.setDescription("The SNA name of the local LU to which this partner LU\ndefinition applies. This field is from 1 to 17 characters in\nlength, including a period (.) which separates the\nNetId from the NAU name if the NetId is present.\n\nThe reserved value '*ALL' indicates that the partner LU\ndefinition applies to all local LUs, and not just to a single\nlocal LU.")
appcLuPairAdminParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcLuPairAdminParLuName.setDescription("The SNA name of the partner LU.\nThis field is from 1 to 17 characters in\nlength, including a period (.) which separates the\nNetId from the NAU name if the NetId is present.")
appcLuPairAdminParLuAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairAdminParLuAlias.setDescription("A local alias for the partner LU.  If not known or\nnot applicable, this object contains a zero-length\nstring.")
appcLuPairAdminSessLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairAdminSessLimit.setDescription("The maximum number of sessions supported by this partner LU.")
appcLuPairAdminSessSec = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,)).subtype(namedValues=NamedValues(("required", 1), ("accepted", 2), ("notAllowed", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairAdminSessSec.setDescription("Specifies the type of session-level security information that\na local LU will accept on BIND requests it receives from the\npartner LU.\n\nrequired    -   Specifies that the BIND request must carry\n                session level verification information that\n                will be verified upon receipt.\naccepted    -   Specifies that the BIND request may carry\n                session level verification information that\n                will be verified upon receipt.\nnotAllowed  -   Specifies that the BIND request must not carry\n                session level verification information.")
appcLuPairAdminSecAccept = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,5,4,)).subtype(namedValues=NamedValues(("none", 1), ("conversation", 2), ("alreadyVerified", 3), ("persistentVerification", 4), ("aVandpV", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairAdminSecAccept.setDescription("Specifies support for different levels of access security\ninformation in ATTACH requests received from this partner LU.\n\nPossible values are:\n\n     none    -   No access security information will be\n                 accepted on allocation requests (ATTACH) from\n                 this LU.\n     conversation\n             -   Allocation requests will not be accepted that\n                 include already verified or persistent\n                 verification indicators.  Accept\n                 conversation-level access security\n                 information, which must include both a user\n                 Id and password, and may also include a\n                 profile.\n     alreadyVerified\n             -   Allocation requests will be accepted that\n                 include already verified indicators.\n                 Persistent verification indicators will not\n                 be accepted.\n     persistentVerification\n             -   Allocation requests will be accepted that\n                 include persistent verification indicators.\n                 Already verified indicators will not be\n                 accepted.\n     aVandpV -   Allocation requests will be accepted that\n                 include already verified or persistent\n                 verification indicators.")
appcLuPairAdminLinkObjId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3, 1, 7), InstancePointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairAdminLinkObjId.setDescription("Specifies the link associated with this partner LU.  This\nvalue points to the row in the table containing information on\nthe link instance.  (e.g., the sdlcLSAdminTable of the SNA DLC\nMIB module).  This object may be NULL if the link is not\nspecified or if a link is not applicable (as for APPN-level\nnodes).")
appcLuPairAdminParaSessSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 3, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairAdminParaSessSup.setDescription("Defined Parallel Sessions Supported.\n\nIndicates whether or not multiple sessions between the partner\nLU and its associated local LU are permitted.  Parallel session\nsupport also indicates that Change Number of Sessions (CNOS)\nwill be used to negotiate session limits between the LUs.")
appcLuPairOperTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4))
if mibBuilder.loadTexts: appcLuPairOperTable.setDescription("Table of active partner/local LU pairs.  Two entries are\npresent in the table when both LUs in a pair are local.")
appcLuPairOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1)).setIndexNames((0, "APPC-MIB", "appcLuPairOperLocLuName"), (0, "APPC-MIB", "appcLuPairOperParLuName"))
if mibBuilder.loadTexts: appcLuPairOperEntry.setDescription("Entry representing one partner/local LU pair.")
appcLuPairOperLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcLuPairOperLocLuName.setDescription("The SNA name of the local LU.  This field is from 1 to 17\ncharacters in length, including a period (.) which separates\nthe NetId from the NAU name if the NetId is present.\n\nIf this object has the same value as appcLluOperName,\nthen the two entries being indexed apply to the same\nresource (specifically, to the same local LU).")
appcLuPairOperParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcLuPairOperParLuName.setDescription("The SNA name of the partner LU.\nThis field is from 1 to 17 characters in\nlength, including a period (.) which separates the\nNetId from the NAU name if the NetId is present.")
appcLuPairOperParLuAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairOperParLuAlias.setDescription("A local alias for the partner LU.  If not known or\nnot applicable, this object contains a zero-length\nstring.")
appcLuPairOperSessLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairOperSessLimit.setDescription("The maximum number of sessions supported by this partner LU.")
appcLuPairOperSessSec = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,)).subtype(namedValues=NamedValues(("required", 1), ("accepted", 2), ("notAllowed", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairOperSessSec.setDescription("Specifies the type of security information that a local LU\nwill accept on BIND requests it receives from the partner LU.\n\nrequired    -   Specifies that the BIND request must carry\n                session level verification information that\n                will be verified upon receipt.\naccepted    -   Specifies that the BIND request may carry\n                session level verification information that\n                will be verified upon receipt.\nnotAllowed  -   Specifies that the BIND request must not carry\n                session level verification information.")
appcLuPairOperSecAccept = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,5,4,)).subtype(namedValues=NamedValues(("none", 1), ("conversation", 2), ("alreadyVerified", 3), ("persistentVerification", 4), ("aVandpV", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairOperSecAccept.setDescription("Specifies support for different levels of security acceptance\ninformation in ATTACH requests received from this partner LU.\n\nPossible values are:\n\n     none    -   No access security information will be\n                 accepted on allocation requests (ATTACH) from\n                 this LU.\n     conversation\n             -   Allocation requests will not be accepted that\n                 include already verified or persistent\n                 verification indicators.  Accept\n                 conversation-level access security\n                 information, which must include both a user\n                 Id and password, and may also include a\n                 profile.\n     alreadyVerified\n             -   Allocation requests will be accepted that\n                 include already verified indicators.\n                 Persistent verification indicators will not\n                 be accepted.\n     persistentVerification\n             -   Allocation requests will be accepted that\n                 include persistent verification indicators.\n                 Already verified indicators will not be\n                 accepted.\n     aVandpV -   Allocation requests will be accepted that\n                 include already verified or persistent\n                 verification indicators.")
appcLuPairOperLinkObjId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 7), InstancePointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairOperLinkObjId.setDescription("Specifies the link associated with this partner LU.  This\nvalue points to the row in the table containing information on\nthe link instance.  (e.g., the sdlcLSAdminTable of the SNA DLC\nMIB module).  This object may be NULL if the link is not\nspecified or if a link is not applicable (as for APPN-level\nnodes).")
appcLuPairOperParaSessSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairOperParaSessSup.setDescription("Active Parallel Sessions Supported.\n\nIndicates whether or not multiple session between the partner\nLU and its associated local LU are permitted.  Parallel\nsession support also indicates that Change Number of Sessions\n(CNOS) will be used to negotiate session limits between the\nLUs.")
appcLuPairOperParaSessSupLS = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairOperParaSessSupLS.setDescription("Active Parallel Sessions Supported - last starting value.\n\nThis object represents the initial value proposed by the local\nLU the last time this capability was negotiated, i.e., when\nthe first session was bound between the local LU and its\npartner.")
appcLuPairOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 4, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("inactive", 1), ("active", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcLuPairOperState.setDescription("The value identifies the current operational state of this LU\npair:\n\n        inactive (1) - no active or pending session exists\n                       between the LUs.\n        active (2)   - an active or pending session exists\n                       between the LUs.")
appcModeAdminTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5))
if mibBuilder.loadTexts: appcModeAdminTable.setDescription("APPC Mode Table")
appcModeAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1)).setIndexNames((0, "APPC-MIB", "appcModeAdminLocLuName"), (0, "APPC-MIB", "appcModeAdminParLuName"), (0, "APPC-MIB", "appcModeAdminModeName"))
if mibBuilder.loadTexts: appcModeAdminEntry.setDescription("Entry of APPC Mode Information Table.")
appcModeAdminLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcModeAdminLocLuName.setDescription("The SNA name of the local LU to which this mode definition\napplies.  This field is from 1 to 17 characters in length,\nincluding a period (.)  which separates the NetId from the\nNAU name if the NetId is present.\n\nThe reserved value '*ALL' indicates that the mode definition\napplies to all local LUs for the SNA node identified by\nappcLocalCpName, and not just to a single local LU.")
appcModeAdminParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcModeAdminParLuName.setDescription("The SNA name of the partner LU to which this mode definition\napplies.  This field is from 1 to 17 characters in length,\nincluding a period (.) which separates the NetId from the\nNAU name if the NetId is present.\n\nThe reserved value '*ALL' indicates that the mode definition\napplies to all partner LUs for the SNA node identified by\nappcModeAdminLocLuName, and not just to a single partner LU.")
appcModeAdminModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcModeAdminModeName.setDescription("Specifies the mode name. A mode defines the characteristics\nfor a group of sessions. The mode name can be blank (8\nspace characters). ")
appcModeAdminCosName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminCosName.setDescription("Specifies the class of service (COS) name associated with\nthis mode.  If the implementation does not support COS names,\na null string is returned.")
appcModeAdminSessEndTpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminSessEndTpName.setDescription("Specifies the name of the transaction program (TP) to be\ninvoked when a session using this mode is deactivated or ended.\nIf no such TP is defined, this object is a null string.  When\nthe TP name consists entirely of displayable EBCDIC code\npoints, it is mapped directly to the equivalent ASCII display\nstring.  However, registered TP names always have a non-\ndisplayable EBCDIC code point (value less than or equal to\nx'3F') as the first character, so they cannot be directly\nmapped to an ASCII display string.  These TP names are\nconverted to a display string that is equivalent to a\nhexadecimal display of the EBCDIC code points.  For example,\nthe 2-byte TP name x'06F1' (CNOS) is converted to the 6-byte\nASCII display string '06F1' (including the two single quotes).")
appcModeAdminMaxSessLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminMaxSessLimit.setDescription("Specifies the maximum value that the local LU is to use,\nduring CNOS processing, for the session limit.  The local LU,\nas a target LU, will negotiate a higher session limit it\nreceives in the CNOS request down to this maximum value.  The\nlocal LU, as a source LU, will restrict the session limit it\nsends in a CNOS request to a value less than or equal to this\nmaximum value.")
appcModeAdminMinCwinLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminMinCwinLimit.setDescription("Specifies the default minimum contention winner sessions\nlimit.  Some implementations internally issue a\nINITIALIZE_SESSION_LIMIT verb when a Mode is created.  This\nvalue is the parameter used for the CNOS processing of that\nverb.  This parameter is not used when issuing an explicit\nINITIALIZE_SESSION_LIMIT verb.  The equivalent object in\nappcCnosCommandTable is used.")
appcModeAdminMinClosLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminMinClosLimit.setDescription("Specifies the default minimum contention loser sessions limit.\nSome implementations internally issue a\nINITIALIZE_SESSION_LIMIT verb when a Mode is created.  This\nvalue is the parameter used for the CNOS processing of that\nverb.  This is the same as target minimum contention winner\nsessions.  This parameter is not used when issuing an explicit\nINITIALIZE_SESSION_LIMIT verb.  The equivalent object in\nappcCnosCommandTable is used.")
appcModeAdminConWinAutoActLmt = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 9), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminConWinAutoActLmt.setDescription("Specifies the limit on the number of contention winner\nsessions to be automatically activated when the minimum number\nof contention winner sessions increases (as a result of CNOS\nprocessing).  The actual number of sessions activated is the\nlesser of this value and the new minimum number of contention\nwinner sessions.  ")
appcModeAdminRecvPacWinSz = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 10), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminRecvPacWinSz.setDescription("Specifies the size of the receive pacing window. This value is\nused for negotiation during session activations (SNA BIND).\n\nThe meaning of this value when set to 0 depends on whether\nadaptive pacing is supported:\n   adaptive pacing        No limit on window size\n   fixed pacing           No pacing is supported")
appcModeAdminSendPacWinSz = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 11), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminSendPacWinSz.setDescription("Specifies the size of the send pacing window. This value is\nused for negotiation during session activations (SNA BIND).\n\nThe meaning of this value when set to 0 depends on whether\nadaptive pacing is supported:\n   adaptive pacing        No limit on window size\n   fixed pacing           No pacing is supported")
appcModeAdminPrefRecvRuSz = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 12), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminPrefRecvRuSz.setDescription("Specifies the preferred receive RU (Request Unit) size of\nnormal-flow requests on the sessions.  This value must be less\nthan or equal to the value specified in\nappcModeAdminRecvRuSzUpBnd and greater than or equal to the\nvalue specified in appcModeAdminRecvRuSzLoBnd.\n\n The local LU specifies this value for the receive maximum RU\n size in session activation (SNA BIND) requests and responses.\n It will allow negotiation up to the appcModeAdminRecvRuSzUpBnd\n value or down to the appcModeAdminRecvRuSzLoBnd value.")
appcModeAdminPrefSendRuSz = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 13), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminPrefSendRuSz.setDescription("Specifies the preferred send RU (Request Unit) size of normal-\nflow requests on the sessions.  This value must be less than or\nequal to the value specified in appcModeAdminSendRuSzUpBnd and\ngreater than or equal to the value specified in\nappcModeAdminSendRuSzLoBnd.\n\n The local LU specifies this value for the send maximum RU\n size in session activation (SNA BIND) requests and responses.\n It will allow negotiation up to the appcModeAdminSendRuSzUpBnd\n value or down to the appcModeAdminSendRuSzLoBnd value.")
appcModeAdminRecvRuSzUpBnd = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 14), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminRecvRuSzUpBnd.setDescription("Specifies the upper bound for the maximum receive RU\n(Request Unit) size of normal-flow requests. This is used\nfor negotiation during session activations (SNA BIND). ")
appcModeAdminSendRuSzUpBnd = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 15), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminSendRuSzUpBnd.setDescription("Specifies the upper bound for the maximum send RU (Request\nUnit) size of normal-flow requests.  This is used for\nnegotiation during session activations (SNA BIND).  ")
appcModeAdminRecvRuSzLoBnd = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 16), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminRecvRuSzLoBnd.setDescription("Specifies the lower bound for the maximum receive RU (Request\nUnit) size of normal-flow requests.  This is used for\nnegotiation during session activations (SNA BIND).  ")
appcModeAdminSendRuSzLoBnd = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 17), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminSendRuSzLoBnd.setDescription("Specifies the lower bound for the maximum send RU (Request\nUnit) size of normal-flow requests.  This is used for\nnegotiation during session activations (SNA BIND).  ")
appcModeAdminSingSessReinit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 18), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,2,5,1,)).subtype(namedValues=NamedValues(("notApplicable", 1), ("operatorControlled", 2), ("primaryOnly", 3), ("secondaryOnly", 4), ("primaryOrSecondary", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminSingSessReinit.setDescription("Specifies the responsibility for session reinitiation of a\nsingle session with the partner LU (when the session goes\ndown).  The local LU uses this parameter to specify the session\nreinitiation responsibility in session activation (SNA BIND)\nrequests and responses.\n\n      notApplicable      - specifies that this parameter has\n                           no meaning since the value of\n                           appcLuPairAdminParaSessSup is yes.\n                           The field in the SNA BIND is\n                           reserved (set to zero).\n      operatorControlled - specifies that neither LU will\n                           automatically attempt to reinitiate\n                           the session.  The operator on either\n                           side will manually reactivate the\n                           session.  A contention race (both\n                           side reinitiating at the same time)\n                           is won by the LU with the\n                           lexicographically greater fully-\n                           qualified LU name.\n      primaryOnly        - specifies that the primary LU will\n                           automatically attempt to reinitiate\n                           the session.\n      secondaryOnly      - specifies that the secondary LU will\n                           automatically attempt to reinitiate\n                           the session.\n      primaryOrSecondary - specifies that either the primary or\n                           the secondary may automatically\n                           attempt to reinitiate the session.\n                           A contention race is handled the\n                           same way as with operatorControlled.")
appcModeAdminCompression = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 19), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("prohibited", 1), ("required", 2), ("negotiable", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminCompression.setDescription("Specifies whether compression is supported.  The local LU uses\nthis value for negotiation during session activation (SNA\nBIND).\n\n    prohibited  -  specifies that no compression is to be used.\n    required    -  specifies that compression is required.\n    negotiable  -  specifies that the usage of compression\n                   is to be negotiated between the LUs. The\n                   level of compression is also negotiated.")
appcModeAdminInBoundCompLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 20), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,5,)).subtype(namedValues=NamedValues(("none", 1), ("rle", 2), ("lz9", 3), ("lz10", 4), ("lz12", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminInBoundCompLevel.setDescription("Specifies the maximum level of compression supported for\ninbound data.  The local LU uses this value in conjunction with\nappcModeAdminCompression for negotiation during session\nactivation (SNA BIND).\n\n    none  -  specifies that no compression is to be used.\n    rle   -  specifies run-length encoding compression\n             in which a 1 or 2 byte sequence substitution is\n             used for each repeated run of the same character.\n    lz9   -  specifies Lempel-Ziv-like compression in which\n             9 bit codes are used to substitute repeated\n             substrings in the data stream.  These codes are\n             indices that refer to entries in a common\n             dictionary generated adaptively at both sender and\n             receiver as the data flows and compression occurs.\n             The larger of number bits used for the code, the\n             more storage space is required for the dictionary,\n             but the larger the compression ratio.\n    lz10  -  specifies a 10 bit code Lempel-Ziv-like compression.\n    lz12  -  specifies a 12 bit code Lempel-Ziv-like compression.")
appcModeAdminOutBoundCompLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 21), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,5,)).subtype(namedValues=NamedValues(("none", 1), ("rle", 2), ("lz9", 3), ("lz10", 4), ("lz12", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminOutBoundCompLevel.setDescription("Specifies the maximum level of compression supported for\noutbound data.  The local LU uses this value in conjunction\nwith appcModeAdminCompression for negotiation during session\nactivation (SNA BIND).\n\n    none  -  specifies that no compression is to be used.\n    rle   -  specifies run-length encoding compression\n             in which a 1 or 2 byte sequence substitution is\n             used for each repeated run of the same character.\n    lz9   -  specifies Lempel-Ziv-like compression in which\n             9 bit codes are used to substitute repeated\n             substrings in the data stream.  These codes are\n             indices that refer to entries in a common\n             dictionary generated adaptively at both sender and\n             receiver as the data flows and compression occurs.\n             The larger of number bits used for the code, the\n             more storage space is required for the dictionary,\n             but the larger the compression ratio.\n    lz10  -  specifies a 10 bit code Lempel-Ziv-like compression.\n    lz12  -  specifies a 12 bit code Lempel-Ziv-like compression.")
appcModeAdminCompRleBeforeLZ = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 22), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminCompRleBeforeLZ.setDescription("Specifies whether run-length encoding is to be applied to the\ndata before applying Lempel-Ziv-like compression.  The local LU\nuses this value for negotiation during session activation (SNA\nBIND).  This parameter is only supported if LZ compression is\nused.")
appcModeAdminSyncLvl = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 23), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("none", 1), ("noneConfirm", 2), ("noneConfirmSyncPoint", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminSyncLvl.setDescription("Specifies the sync level support. This value is used for\nnegotiation during session activations (SNA BIND).\n\n     none                 - No sync level is supported.\n     noneConfirm          - None and Confirm levels supported.\n     noneConfirmSyncPoint - None, Confirm, and Sync Point is\n                            supported.")
appcModeAdminCrypto = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 5, 1, 24), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("notSupported", 1), ("mandatory", 2), ("selective", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeAdminCrypto.setDescription("Specifies whether session-level cryptography is supported.\nThis value is used for negotiation during session activations\n(SNA BIND).\n     notSupported    -   Specifies session-level cryptography\n                         is not to be used.\n     mandatory       -   Specifies session-level cryptography\n                         must be used.\n     selective       -   Specifies session-level cryptography\n                         is required just on selected requests\n                         flowing on the sessions.")
appcModeOperTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6))
if mibBuilder.loadTexts: appcModeOperTable.setDescription("Operational APPC Mode Information.  Two entries are present in\nthe table when both LUs in a pair are local.")
appcModeOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1)).setIndexNames((0, "APPC-MIB", "appcModeOperLocLuName"), (0, "APPC-MIB", "appcModeOperParLuName"), (0, "APPC-MIB", "appcModeOperModeName"))
if mibBuilder.loadTexts: appcModeOperEntry.setDescription("Entry of APPC mode operational information table.  This entry\ndoes not augment the appcModeAdminEntry, but reflects an actual\noperational mode for a given local LU - partner LU pair.")
appcModeOperLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcModeOperLocLuName.setDescription("The SNA name of the local LU.  This field is from 1 to 17\ncharacters in length, including a period (.) which separates\nthe NetId from the NAU name if the NetId is present.\nIf this object has the same value as appcLluOperName,\nthen the two entries being indexed apply to the same\nresource (specifically, to the same local LU).")
appcModeOperParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcModeOperParLuName.setDescription("The SNA name of the partner LU.  This field is from 1 to 17\ncharacters in length, including a period (.) which separates\nthe NetId from the NAU name if the NetId is present.\n\nIf this object has the same value as appcLuPairOperParLuName,\nthen the two entries being indexed apply to the same\nresource (specifically, to the same partner LU).")
appcModeOperModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcModeOperModeName.setDescription("Specifies the mode name. A mode defines the characteristics\nfor a group of sessions. The mode name can be blank (8\nspace characters). ")
appcModeOperCosName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperCosName.setDescription("Specifies the class of service (COS) name associated with\nthis mode.  If the implementation does not support COS names,\na zero-length string is returned.")
appcModeOperSessEndTpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperSessEndTpName.setDescription("Specifies the name of the transaction program (TP) to be\ninvoked when a session using this mode is deactivated or ended.\nIf the name is NULL, no transaction program is invoked.  When\nthe TP name consists entirely of displayable EBCDIC code\npoints, it is mapped directly to the equivalent ASCII display\nstring.  However, registered TP names always have a non-\ndisplayable EBCDIC code point (value less than or equal to\nx'3F') as the first character, so they cannot be directly\nmapped to an ASCII display string.  These TP names are\nconverted to a display string that is equivalent to a\nhexadecimal display of the EBCDIC code points.  For example,\nthe 2-byte TP name x'06F1' (CNOS) is converted to the 6-byte\nASCII display string '06F1' (including the two single quotes).")
appcModeOperSessLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperSessLimit.setDescription("Specifies the current session limit of this mode as negotiated\nthrough APPC CNOS (Change Number of Sessions) processing.\nIdentifies the total number of sessions that can be established\nbetween the local and partner LU using this mode.")
appcModeOperMaxSessLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperMaxSessLimit.setDescription("Specifies the maximum value that the local LU is to use,\nduring CNOS processing, for the session limit.  The local LU,\nas a target LU, will negotiate a higher session limit it\nreceives in the CNOS request down to this maximum value.  The\nlocal LU, as a source LU, will restrict the session limit it\nsends in a CNOS request to a value less than or equal to this\nmaximum value.")
appcModeOperMinCwinLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperMinCwinLimit.setDescription("Specifies the minimum contention winner sessions limit that\nwas negotiated via CNOS processing.")
appcModeOperMinClosLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 9), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperMinClosLimit.setDescription("Specifies the minimum contention loser sessions limit that\nwas negotiated via CNOS processing. This is the same as\ntarget minimum contention winner sessions.")
appcModeOperConWinAutoActLmt = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 10), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperConWinAutoActLmt.setDescription("Specifies the limit on the number of contention winner sessions\nto be automatically activated when the minimum number of\ncontention winner sessions increases (as a result of CNOS\nprocessing). The actual number of sessions activated is the\nlesser of this value and the new minimum number of contention\nwinner sessions. ")
appcModeOperRecvPacWinSz = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 11), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperRecvPacWinSz.setDescription("Specifies the size of the receive pacing window. This value is\nused for negotiation during session activations (SNA BIND).\n\nThe meaning of this value when set to 0 depends on whether\nadaptive pacing is supported:\n   adaptive pacing   -     No limit on window size\n   fixed pacing      -     No pacing is supported")
appcModeOperSendPacWinSz = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 12), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperSendPacWinSz.setDescription("Specifies the size of the send pacing window. This value is\nused for negotiation during session activations (SNA BIND).\n\nThe meaning of this value when set to 0 depends on whether\nadaptive pacing is supported:\n   adaptive pacing        No limit on window size\n   fixed pacing           No pacing is supported")
appcModeOperPrefRecvRuSz = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 13), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperPrefRecvRuSz.setDescription("Specifies the preferred receive RU (Request Unit) size of\nnormal-flow requests on the sessions.  This value must be less\nthan or equal to the value specified in\nappcModeOperRecvRuSzUpBnd and greater than or equal to the\nvalue specified in appcModeOperRecvRuSzLoBnd.\n\n The local LU specifies this value for the receive maximum RU\n size in session activation (SNA BIND) requests and responses.\n It will allow negotiation up to the appcModeOperRecvRuSzUpBnd\n value or down to the appcModeOperRecvRuSzLoBnd value.")
appcModeOperPrefSendRuSz = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 14), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperPrefSendRuSz.setDescription("Specifies the preferred send RU (Request Unit) size of normal-\nflow requests on the sessions.  This value must be less than or\nequal to the value specified in appcModeOperSendRuSzUpBnd and\ngreater than or equal to the value specified in\nappcModeOperSendRuSzLoBnd.\n\n The local LU specifies this value for the send maximum RU\n size in session activation (SNA BIND) requests and responses.\n It will allow negotiation up to the appcModeOperSendRuSzUpBnd\n value or down to the appcModeOperSendRuSzLoBnd value.")
appcModeOperRecvRuSzUpBnd = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 15), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperRecvRuSzUpBnd.setDescription("Specifies the upper bound for the maximum receive RU\n(Request Unit) size of normal-flow requests. This is used\nfor negotiation during session activations (SNA BIND). ")
appcModeOperSendRuSzUpBnd = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 16), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperSendRuSzUpBnd.setDescription("Specifies the upper bound for the maximum send RU (Request\nUnit) size of normal-flow requests.  This is used for\nnegotiation during session activations (SNA BIND).  ")
appcModeOperRecvRuSzLoBnd = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 17), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperRecvRuSzLoBnd.setDescription("Specifies the lower bound for the maximum receive RU\n(Request Unit) size of normal-flow requests. This is used\nfor negotiation during session activations (SNA BIND). ")
appcModeOperSendRuSzLoBnd = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 18), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperSendRuSzLoBnd.setDescription("Specifies the lower bound for the maximum send RU\n(Request Unit) size of normal-flow requests. This is used\nfor negotiation during session activations (SNA BIND). ")
appcModeOperSingSessReinit = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 19), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,2,5,1,)).subtype(namedValues=NamedValues(("notApplicable", 1), ("operatorControlled", 2), ("primaryOnly", 3), ("secondaryOnly", 4), ("primaryOrSecondary", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperSingSessReinit.setDescription("Specifies the responsibility for session reinitiation of a\nsingle session with the partner LU (when the session goes\ndown).  The local LU uses this parameter to specify the session\nreinitiation responsibility in session activation (SNA BIND)\nrequests and responses.\n\n      notApplicable      - specifies that this parameter has\n                           no meaning since the value of\n                           appcLuPairOperParaSessSup is yes.\n                           The field in the SNA BIND is\n                           reserved (set to zero).\n      operatorControlled - specifies that neither LU will\n                           automatically attempt to reinitiate\n                           the session.  The operator on either\n                           side will manually reactivate the\n                           session.  A contention race (both\n                           side reinitiating at the same time)\n                           is won by the LU with the\n                           lexicographically greater fully-\n                           qualified LU name.\n      primaryOnly        - specifies that the primary LU will\n                           automatically attempt to reinitiate\n                           the session.\n      secondaryOnly      - specifies that the secondary LU will\n                           automatically attempt to reinitiate\n                           the session.\n      primaryOrSecondary - specifies that either the primary or\n                           the secondary may automatically\n                           attempt to reinitiate the session.\n                           A contention race is handled the\n                           same way as with operatorControlled.")
appcModeOperCompression = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 20), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("prohibited", 1), ("required", 2), ("negotiable", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperCompression.setDescription("Specifies whether compression is supported.  The local LU uses\nthis value for negotiation during session activation (SNA\nBIND).\n\n    prohibited  -  specifies that no compression is to be used.\n    required    -  specifies that compression is required.\n    negotiable  -  specifies that the usage of compression\n                   is to be negotiated between the LUs. The\n                   level of compression is also negotiated.")
appcModeOperInBoundCompLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 21), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,5,)).subtype(namedValues=NamedValues(("none", 1), ("rle", 2), ("lz9", 3), ("lz10", 4), ("lz12", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperInBoundCompLevel.setDescription("Specifies the maximum level of compression supported for\ninbound data.  The local LU uses this value in conjunction with\nappcModeOperCompression for negotiation during session\nactivation (SNA BIND).\n\n    none  -  specifies that no compression is to be used.\n    rle   -  specifies run-length encoding compression\n             in which a 1 or 2 byte sequence substitution is\n             used for each repeated run of the same character.\n    lz9   -  specifies Lempel-Ziv-like compression in which\n             9 bit codes are used to substitute repeated\n             substrings in the data stream.  These codes are\n             indices that refer to entries in a common\n             dictionary generated adaptively at both sender and\n             receiver as the data flows and compression occurs.\n             The larger of number bits used for the code, the\n             more storage space is required for the dictionary,\n             but the larger the compression ratio.\n    lz10  -  specifies a 10 bit code Lempel-Ziv-like compression.\n    lz12  -  specifies a 12 bit code Lempel-Ziv-like compression.")
appcModeOperOutBoundCompLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 22), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,5,)).subtype(namedValues=NamedValues(("none", 1), ("rle", 2), ("lz9", 3), ("lz10", 4), ("lz12", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperOutBoundCompLevel.setDescription("Specifies the maximum level of compression supported for\noutbound data.  The local LU uses this value in conjunction\nwith appcModeOperCompression for negotiation during session\nactivation (SNA BIND).\n\n    none  -  specifies that no compression is to be used.\n    rle   -  specifies run-length encoding compression\n             in which a 1 or 2 byte sequence substitution is\n             used for each repeated run of the same character.\n    lz9   -  specifies Lempel-Ziv-like compression in which\n             9 bit codes are used to substitute repeated\n             substrings in the data stream.  These codes are\n             indices that refer to entries in a common\n             dictionary generated adaptively at both sender and\n             receiver as the data flows and compression occurs.\n             The larger of number bits used for the code, the\n             more storage space is required for the dictionary,\n             but the larger the compression ratio.\n    lz10  -  specifies a 10 bit code Lempel-Ziv-like compression.\n    lz12  -  specifies a 12 bit code Lempel-Ziv-like compression.")
appcModeOperCompRleBeforeLZ = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 23), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperCompRleBeforeLZ.setDescription("Specifies whether run-length encoding is to be applied to the\ndata before applying Lempel-Ziv-like compression.  The local LU\nuses this value for negotiation during session activation (SNA\nBIND).  This parameter is only supported if LZ compression is\nused.")
appcModeOperSyncLvl = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 24), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("none", 1), ("noneConfirm", 2), ("noneConfirmSyncPoint", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperSyncLvl.setDescription("Specifies the sync level support for sessions involving this\nLU pair and mode name.\n\n     none             -       No sync level is supported.\n     noneConfirm      -       None and Confirm level supported.\n     noneConfirmSyncPoint -   None, Confirm and Sync Point is\n                                     supported.")
appcModeOperCrypto = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 25), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("notSupported", 1), ("mandatory", 2), ("selective", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperCrypto.setDescription("Specifies whether session-level cryptography is supported for\nsessions involving this LU pair and mode name.\n\n     notSupported    -   Specifies session-level cryptography\n                            is not being used.\n     mandatory       -   Specifies session-level cryptography\n                            in being used on all requests\n                            flowing on the sessions.\n     selective       -   Specifies session-level cryptography\n                            is required just on selected\n                            requests flowing on the sessions.")
appcModeOperSyncLvlLastStart = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 26), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("none", 1), ("noneConfirm", 2), ("noneConfirmSyncPoint", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperSyncLvlLastStart.setDescription("Specifies the sync level support.  This value represents the\ninitial value proposed by the local LU the last time this\ncapability was negotiated, i.e., when the first session was\nbound between the local LU and its partner.\n\n      none             -      No sync level is supported.\n      noneConfirm      -      None and Confirm level supported.\n      noneConfirmSyncPoint -  None, Confirm and Sync Point is\n                                  supported.")
appcModeOperCryptoLastStart = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 27), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("notSupported", 1), ("mandatory", 2), ("selective", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperCryptoLastStart.setDescription("Specifies whether session-level cryptography is supported.\nThis value represents the initial value proposed by the local\nLU the last time this capability was negotiated, i.e., when\nthe first session was bound between the local LU and its\npartner.\n     notSupported    -   Specifies session-level cryptography\n                            is not to be used.\n     mandatory       -   Specifies session-level cryptography\n                            must be used.\n     selective       -   Specifies session-level cryptography\n                            is required just on selected\n                            requests flowing on the sessions.")
appcModeOperCNOSNeg = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 28), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperCNOSNeg.setDescription("Specifies whether CNOS negotiation is in process.  CNOS\nnegotiation is used to set or change the various session limits\nfor a mode.")
appcModeOperActCwin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 29), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperActCwin.setDescription("Specifies the number of active contention winner sessions.")
appcModeOperActClos = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 30), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperActClos.setDescription("Specifies the number of active contention loser sessions.")
appcModeOperPndCwin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 31), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperPndCwin.setDescription("Specifies the number of contention winner sessions that are\npending activation.")
appcModeOperPndClos = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 32), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperPndClos.setDescription("Specifies the number of contention loser sessions that are\npending activation.")
appcModeOperPtmCwin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 33), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperPtmCwin.setDescription("Specifies the number of contention winner sessions that are\npending termination.")
appcModeOperPtmClos = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 34), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperPtmClos.setDescription("Specifies the number of contention loser sessions that are\npending termination.")
appcModeOperDrainSelf = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 35), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperDrainSelf.setDescription("Specifies whether the local LU is draining its conversations\nfor this mode.  When a mode session limit is reset (via a CNOS\nRESET_SESSION_LIMIT request), the local LU could be set to\nprocess all queued conversations before deactivating all of the\nsessions (using the SNA Bracket Initiation Stopped or BIS\nprotocol).  ")
appcModeOperDrainPart = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 2, 6, 1, 36), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcModeOperDrainPart.setDescription("Specifies whether the partner LU is draining its conversations\nfor this mode.  When a mode session limit is reset (via a CNOS\nRESET_SESSION_LIMIT request), the partner LU could be set to\nprocess all queued conversations before deactivating all of the\nsessions (using the SNA Bracket Initiation Stop or BIS\nprotocol).  ")
appcTp = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 3))
appcTpAdminTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1))
if mibBuilder.loadTexts: appcTpAdminTable.setDescription("APPC Local TP Table")
appcTpAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1)).setIndexNames((0, "APPC-MIB", "appcTpAdminLocLuName"), (0, "APPC-MIB", "appcTpAdminTpName"))
if mibBuilder.loadTexts: appcTpAdminEntry.setDescription("Entry of APPC Local TP Information Table.")
appcTpAdminLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcTpAdminLocLuName.setDescription("The SNA name of the local LU to which this TP definition\napplies. This field is from 1 to 17 characters in length,\nincluding a period (.) which separates the NetId from the NAU\nname if the NetId is present.\n\nThe reserved value '*ALL' indicates that the TP definition\napplies to all local LUs, and not just to a single local LU.")
appcTpAdminTpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 64))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcTpAdminTpName.setDescription("The local transaction program name. This name is sent on an\nATTACH remote allocation request.\n\nWhen the TP name consists entirely of displayable EBCDIC\ncode points, it is mapped directly to the equivalent ASCII\ndisplay string.  However, registered TP names always have a\nnon-displayable EBCDIC code point (value less than or equal to\nx'3F') as the first character, so they cannot be directly\nmapped to an ASCII display string.  These TP names are\nconverted to a display string that is equivalent to a\nhexadecimal display of the EBCDIC code points.  For example,\nthe 2-byte TP name x'06F1' (CNOS) is converted to the 6-byte\nASCII display string '06F1' (including the two single quotes).")
appcTpAdminFileSpec = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 80))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminFileSpec.setDescription("The local file specification of the transaction program.\nMay be a zero-length string if not applicable.")
appcTpAdminStartParm = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminStartParm.setDescription("A parameter string passed to the transaction program when it\nis started.  May be a zero-length string if not supported. ")
appcTpAdminTpOperation = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(4,3,5,1,2,)).subtype(namedValues=NamedValues(("other", 1), ("queuedOperatorStarted", 2), ("queuedOperatorPreloaded", 3), ("queuedAmStarted", 4), ("nonqueuedAmStarted", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminTpOperation.setDescription("Specifies how the program will be started.\nother - Specifies that the program operation is none of\n        the methods specified. It may be a\n        product-specific method.\n\nqueuedOperatorStarted - Specifies that one version of the\n        program will be run at a time.  If an incoming\n        attach arrives and the program has not been started\n        yet, APPC will issue a message to the operator to\n        start the specified program.  Subsequent attaches\n        that arrive while the program is active will be\n        queued.\n\nqueuedOperatorPreloaded - Specifies that one version of the\n        program will be run at a time.  If an incoming\n        attach arrives and the program has not been started\n        yet, the Attach will be rejected.  The APPC attach\n        manager determines that a TP has started upon\n        reception of an APPC RECEIVE_ALLOCATE verb, or a\n        CPI-C Accept_Conversation (CMACCP) or\n        Specify_Local_TP_Name (CMSLTP) call.  No message is\n        sent to the operator.  Subsequent attaches that\n        arrive while the program is active are queued.\n\nqueuedAmStarted - Specifies that one version of the\n        program will be run at a time and will be started\n        by the APPC attach manager.  Subsequent attaches\n        that arrive while the program is active will be\n        queued.\n\nnonqueuedAmStarted - Specifies that multiple copies of the\n        program will be run at a time and will be started\n        by the APPC attach manager.")
appcTpAdminInAttachTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminInAttachTimeout.setDescription("This object specifies the number of seconds incoming attaches\nwill be queued waiting for an APPC program to issue a\nRECEIVE_ALLOCATE verb or for a CPI-C program to issue an\nAccept_Conversation (CMACCP) call.  This parameter is\nmeaningful only when appcTpAdminTpOperation has one of the\nfollowing values:\n           queuedOperatorStarted\n           queuedOperatorPreloaded\n           queuedAmStarted\n\nA value of zero indicates that there is no timeout.")
appcTpAdminRcvAllocTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminRcvAllocTimeout.setDescription("This object specifies the number of seconds an APPC program's\nRECEIVE_ALLOCATE verb or a CPI-C program's Accept_Conversation\n(CMACCP) call will wait for an incoming attach to arrive.\n\nA value of zero indicates that there is no timeout.")
appcTpAdminSyncLvl = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(1,6,4,3,2,7,5,)).subtype(namedValues=NamedValues(("none", 1), ("confirm", 2), ("noneAndConfirm", 3), ("syncpoint", 4), ("noneAndSyncpoint", 5), ("confirmAndSyncpoint", 6), ("all", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminSyncLvl.setDescription("Indicates the synchronization level or levels that the\ntransaction program supports.  The levels are defined as\nfollows:\n\n     none      - allocation requests indicating a\n                 synchronization level of none are allowed to\n                 start the program.\n     confirm   - allocation requests indicating a\n                 synchronization level of confirm are allowed\n                 to start the program.\n     syncpoint - allocation requests indicating a\n                 synchronization level of sync point are\n                 allowed to start the program.")
appcTpAdminInstLmt = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 9), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminInstLmt.setDescription("The maximum number of concurrent instances of this transaction\nprogram that will be supported for a local LU.  A value of\nzero indicates that there is no limit.")
appcTpAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("enabled", 1), ("tempDisabled", 2), ("permDisabled", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminStatus.setDescription("Indicates the status of the TP relative to starting execution\nwhen the local LU receives an allocation (ATTACH) request\nnaming this program.\n\n      enabled         -    the local LU can start the program.\n      tempDisabled    -    the local LU cannot start the\n                           program. The local LU rejects the\n                           request with an indication that the\n                           TP is not available but retry is\n                           possible.\n      permDisabled    -    the local LU cannot start the\n                           program. The local LU rejects the\n                           request with an indication that the\n                           TP is not available and retry is\n                           not possible.")
appcTpAdminLongRun = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminLongRun.setDescription("Indicates whether this is a long-running transaction program\n(i.e., one that stays around even after the conversation goes\naway).")
appcTpAdminConvType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("basic", 1), ("mapped", 2), ("basicOrMapped", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminConvType.setDescription("Specifies the conversation type (basic or mapped) that will be\nused by the TP.  This value is verified upon receipt of an\nincoming attach.  The acceptable values are:\n\n       basic         - Indicates that this transaction program\n                       supports basic conversations.\n\n       mapped        - Indicates that this transaction program\n                       supports mapped conversations.\n\n       basicOrMapped - Indicates that this transaction program\n                       supports both basic and mapped\n                       conversations.")
appcTpAdminConvDuplex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 13), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("half", 1), ("full", 2), ("halfOrFull", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminConvDuplex.setDescription("Specifies the conversation duplex type (half or full) that\nwill be used by the TP.  This value is verified upon receipt of\nan incoming attach.  The acceptable values are:\n\n       half       - Indicates that this transaction program\n                    supports half duplex conversations.\n\n       full       - Indicates that this transaction program\n                    supports full duplex conversations.\n\n       halfOrFull - Indicates that this transaction program\n                    supports either half or full duplex\n                    conversations.")
appcTpAdminConvSecReq = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminConvSecReq.setDescription("Indicates whether conversation-level security information is\nrequired on incoming attaches designating this TP name.\nConversation-level security verification is always performed on\nthose requests that include security information.\n\n       yes - Indicates that conversation-level security\n             information is required.  ATTACHs designating the\n             transaction program must carry a user_id and\n             either a password or an already verified\n             indicator.\n\n       no  - Indicates that no security information is\n             required.  ATTACHs designating the transaction\n             program can omit or include security information.")
appcTpAdminVerPip = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 15), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminVerPip.setDescription("Specifies whether the number of PIP (Program Initialization\nParameters) subfields should be verified against the number\nexpected (appcTpAdminPipSubNum).")
appcTpAdminPipSubNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 3, 1, 1, 16), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcTpAdminPipSubNum.setDescription("Specifies the number of PIP subfields expected by the TP.")
appcSession = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 4))
appcActSessTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1))
if mibBuilder.loadTexts: appcActSessTable.setDescription("Table of active APPC sessions.  Two entries are present in the\ntable when both session partners are local.")
appcActSessEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1)).setIndexNames((0, "APPC-MIB", "appcActSessLocLuName"), (0, "APPC-MIB", "appcActSessParLuName"), (0, "APPC-MIB", "appcActSessIndex"))
if mibBuilder.loadTexts: appcActSessEntry.setDescription("Entry of APPC Session Information Table.  Indexed by LU pair\nand integer-valued session index.")
appcActSessLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcActSessLocLuName.setDescription("Specifies the name of the local LU for the session.  This\nfield is from 1 to 17 characters in length, including a period\n(.) which separates the NetId from the NAU name if the NetId is\npresent.\n\nIf this object has the same value as appcLluOperName, then the\ntwo entries being indexed apply to the same resource\n(specifically, to the same local LU).")
appcActSessParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcActSessParLuName.setDescription("Specifies the name of the partner LU for the session.  This\nfield is from 1 to 17 characters in length, including a period\n(.) which separates the NetId from the NAU name if the NetId is\npresent.\n\nIf this object has the same value as appcLuPairOperParLuName,\nthen the two entries being indexed apply to the same resource\n(specifically, to the same partner LU).")
appcActSessIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 3), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcActSessIndex.setDescription("This value identifies the index of the session, which is\nunique for this LU pair.  It is recommended that an Agent not\nreuse the index of a deactivated session for a significant\nperiod of time (e.g., one week).")
appcActSessPcidCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 4), DisplayString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,17),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessPcidCpName.setDescription("The network-qualified CP name of the node at which the session\nand PCID originated.  For APPN and LEN nodes, this is either CP\nname of the APPN node at which the origin LU is located or the\nCP name of the NN serving the LEN node at which the origin LU\nis located.  This field is from 3 to 17 characters in length,\nincluding a period (.) which separates the NetId from the NAU\nname.  A null string indicates that the value is unknown.")
appcActSessPcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 5), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(8,8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessPcid.setDescription("The procedure correlation identifier (PCID) of a session.  It\nis an 8-octet value assigned by the control point providing\nsession services for the primary LU.  A null string indicates\nthat the value is unknown.")
appcActSessPluIndicator = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("localLuIsPlu", 1), ("partnerLuIsPlu", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessPluIndicator.setDescription("Indicates which LU is the PLU for this session.  For\nindependent LUs, the PLU (primary LU) is the one that initiated\nthe session (sent BIND), while the SLU (secondary LU) is the\none that accepted the session initiation (received BIND).\n\nThe 'local' LU is the one identified by appcLluOperName.\n\nThe 'partner' LU is the one identified by\nappcLuPairOperParLuName.")
appcActSessModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 7), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessModeName.setDescription("The mode name used for this session.")
appcActSessCosName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 8), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessCosName.setDescription("The Class of Service (COS) name used for this session.\nA null string indicates that the value is unknown.")
appcActSessTransPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(3,5,1,4,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("low", 2), ("medium", 3), ("high", 4), ("network", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessTransPriority.setDescription("The transmission priority of this session.\n1 = unknown priority\n2 = low priority\n3 = medium priority\n4 = high priority\n5 = network priority")
appcActSessEnhanceSecSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("none", 1), ("level1", 2), ("level2", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessEnhanceSecSup.setDescription("Enhanced security supported. Indicates the level of enhanced\nsecurity support:\n\n   1 = none\n   2 = level 1\n   3 = level 2")
appcActSessSendPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("none", 1), ("fixed", 2), ("adaptive", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessSendPacingType.setDescription("The type of pacing being used for sending data.")
appcActSessSendRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessSendRpc.setDescription("The send residual pace count.  This represents the number of\nMUs that can still be sent in the current session window.")
appcActSessSendNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessSendNxWndwSize.setDescription("The size of the next window which will be used to send data.")
appcActSessRecvPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("none", 1), ("fixed", 2), ("adaptive", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessRecvPacingType.setDescription("The type of pacing being used for receiving data.")
appcActSessRecvRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 15), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessRecvRpc.setDescription("The receive residual pace count.  This represents the number\nof MUs that can still be received in the current session\nwindow.")
appcActSessRecvNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 16), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessRecvNxWndwSize.setDescription("The size of the next window which will be used to receive\ndata.")
appcActSessRscv = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 17), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessRscv.setDescription("The route selection control vector (RSCV CV2B) used for this\nsession.  It is present for APPN-level implementations.\nLEN-level implementations will return a null string.  The\ninternal format of this vector is described in SNA Formats.\nThis object contains an uninterpreted copy of the control\nvector (including the length and key fields).")
appcActSessInUse = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 18), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("no", 1), ("yes", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessInUse.setDescription("Specifies whether the session is currently in use (i.e., in\nbracket with a conversation).")
appcActSessMaxSndRuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 8192))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessMaxSndRuSize.setDescription("The maximum RU size used on this session for sending RUs.")
appcActSessMaxRcvRuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 8192))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessMaxRcvRuSize.setDescription("The maximum RU size used on this session for receiving RUs.")
appcActSessSndPacingSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessSndPacingSize.setDescription("The size of the send pacing window on this session.")
appcActSessRcvPacingSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 22), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessRcvPacingSize.setDescription("The size of the receive pacing window on this session.")
appcActSessOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 23), Integer().subtype(subtypeSpec=SingleValueConstraint(4,2,1,3,)).subtype(namedValues=NamedValues(("unbound", 1), ("pendingBind", 2), ("bound", 3), ("pendingUnbind", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appcActSessOperState.setDescription("The value indicates the current operational state of the\nsession.\n\n        'unbound (1)' - session has been  unbound;\n              in this state it will be removed from the\n              session table by the Agent.\n\n        'pendingBind (2)' - this state has different\n              meanings for dependent and independent LUs;\n              for dependent LU - waiting for BIND from\n              the host, for independent LU - waiting for\n              BIND response.  When a session enters this\n              state, the corresponding entry in the\n              session table is created by the Agent.\n\n        'bound (3)' - session has been successfully bound.\n\n        'pendingUnbind (4)' - session enters this state\n              when an UNBIND is sent and before the\n              rsp(UNBIND) is received.\n\nSession deactivation:\n\n        If a session is in the operational state\n        'bound (3)' then setting the value of this\n        object to 'unbound (1)' will initiate the\n        session shutdown.\n\n        If a session is in the operational state\n        'pendingBind (2)' then setting the value of this\n        object to 'unbound (1)' will initiate the session\n        shutdown.\n\n        If a session is in the operational state\n        'pendingUnbind (4)' for an abnormally long period\n        of time (e.g., three minutes) then setting the value\n        of this object to 'unbound (1)' will change the\n        session operational state to 'unbound (1)'. ")
appcActSessUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 24), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessUpTime.setDescription("The length of time the session has been active, measured in\nhundredths of a second.")
appcActSessRtpNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 25), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessRtpNceId.setDescription("The local HPR Network Connection Endpoint of the session.")
appcActSessRtpTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 26), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(8,8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessRtpTcid.setDescription("The local RTP connection TCID of the session.")
appcActSessLinkIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 1, 1, 27), InstancePointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActSessLinkIndex.setDescription("This value identifies the link over which the session passes.\nThis value points to the row in the table containing\ninformation on the link instance.  (e.g., the sdlcLSAdminTable\nof the SNA DLC MIB module).  This object may be NULL if the\nlink is not specified or if a link is not applicable (as for\nAPPN-level nodes).")
appcSessStatsTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2))
if mibBuilder.loadTexts: appcSessStatsTable.setDescription("This table contains dynamic statistical information relating\nto active APPC sessions.  The entries in this table cannot be\ncreated by a Management Station.  Two entries are present in\nthe table when both session partners are local.  This table is\npopulated only when the value of appcCntrlOperStat is\n'active'.")
appcSessStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1)).setIndexNames((0, "APPC-MIB", "appcSessStatsLocLuName"), (0, "APPC-MIB", "appcSessStatsParLuName"), (0, "APPC-MIB", "appcSessStatsSessIndex"))
if mibBuilder.loadTexts: appcSessStatsEntry.setDescription("Contains statistics information for an APPC session.  Each\nentry is created by the Agent.  Objects in this table have\nread-only access.  Each session from appcActSessTable has one\nentry in this table.")
appcSessStatsLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcSessStatsLocLuName.setDescription("Specifies the name of the local LU for the session.  This\nfield is from 1 to 17 characters in length, including a period\n(.) which separates the NetId from the NAU name if the NetId is\npresent.\n\nIf this object has the same value as appcLluOperName, then the\ntwo entries being indexed apply to the same resource\n(specifically, to the same local LU).")
appcSessStatsParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcSessStatsParLuName.setDescription("Specifies the name of the partner LU for the session.  This\nfield is from 1 to 17 characters in length, including a period\n(.) which separates the NetId from the NAU name if the NetId is\npresent.\n\nIf this object has the same value as appcLuPairOperParLuName,\nthen the two entries being indexed apply to the same resource\n(specifically, to the same partner LU).")
appcSessStatsSessIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 3), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcSessStatsSessIndex.setDescription("This value identifies the index of the session, which is\nunique for this LU pair.  It is recommended that an Agent not\nreuse the index of a deactivated session for a significant\nperiod of time (e.g., one week).\n\nIf this object has the same value as appcActSessIndex for the\nsame LU pair, then the two entries being indexed apply to the\nsame resource (specifically, to the same session).")
appcSessStatsSentFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessStatsSentFmdBytes.setDescription("The number of function management data (FMD) bytes sent by the\nlocal LU.")
appcSessStatsSentNonFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessStatsSentNonFmdBytes.setDescription("The number of non-function management data (non-FMD) bytes\nsent by the local LU.")
appcSessStatsRcvdFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessStatsRcvdFmdBytes.setDescription("The number of function management data (FMD) bytes received by\nthe local LU.")
appcSessStatsRcvdNonFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessStatsRcvdNonFmdBytes.setDescription("The number of non-function management data (non-FMD) bytes\nreceived by the local LU.")
appcSessStatsSentFmdRus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessStatsSentFmdRus.setDescription("The number of function management data (FMD) RUs sent by the\nlocal LU.")
appcSessStatsSentNonFmdRus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessStatsSentNonFmdRus.setDescription("The number of non-function management data (non-FMD) RUs sent\nby the local LU.")
appcSessStatsRcvdFmdRus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessStatsRcvdFmdRus.setDescription("The number of function management data (FMD) RUs received by\nthe local LU.")
appcSessStatsRcvdNonFmdRus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessStatsRcvdNonFmdRus.setDescription("The number of non-function management data (non-FMD) RUs\nreceived by the local LU.")
appcSessStatsCtrUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 2, 1, 12), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessStatsCtrUpTime.setDescription("The length of time the counters for this session have been\nactive, measured in hundredths of a second.")
appcHistSessTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3))
if mibBuilder.loadTexts: appcHistSessTable.setDescription("Table of historical information about APPC sessions that\nterminated abnormally.  Two entries may be present in the table\nwhen both session partners are local.  It is an implementation\nchoice how long to retain information about a given session.")
appcHistSessEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1)).setIndexNames((0, "APPC-MIB", "appcHistSessIndex"))
if mibBuilder.loadTexts: appcHistSessEntry.setDescription("Entry of APPC Session History Table.  This table is indexed by\nan integer which is continuously incremented until it\neventually wraps.")
appcHistSessIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcHistSessIndex.setDescription("Table index.  The value of the index begins at zero\nand is incremented up to a maximum value of 2**31-1\n(2,147,483,647) before wrapping.")
appcHistSessTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistSessTime.setDescription("The time at which the session was either terminated or\nfailed to be established.")
appcHistSessType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,2,3,5,)).subtype(namedValues=NamedValues(("recvNegBindRsp", 1), ("sendNegBindRsp", 2), ("sessActRejected", 3), ("unbindSent", 4), ("unbindReceived", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistSessType.setDescription("Indicates the type of event that caused the entry to be made:\n\nrecvNegBindRsp  - Received a negative bind response from\n                  the partner LU.\nsendNegBindRsp  - Sent a negative bind response to the\n                  partner LU.\nsessActRejected - Session activation rejected by the\n                  partner LU.\nunbindSent      - Unbind sent to the partner LU.\nunbindReceived  - Unbind received from the partner LU.\n\nThese event types correspond to the five SNA/MS Alerts\nLU62001 through LU62005, documented in the SNA Management\nServices Reference.")
appcHistSessLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistSessLocLuName.setDescription("The network-qualified local LU name.  This field is from 3 to\n17 characters in length, including a period (.) which separates\nthe NetId from the NAU name if the NetId is present.")
appcHistSessParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(3, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistSessParLuName.setDescription("The network-qualified partner LU name.  This field is from 3\nto 17 characters in length, including a period (.) which\nseparates the NetId from the NAU name if the NetId is present.")
appcHistSessModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 6), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistSessModeName.setDescription("The mode name of the session.")
appcHistSessUnbindType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistSessUnbindType.setDescription("The type of unbind which terminated the session.  This\nvalue is consists of one (1) octet; and its meaning\nis defined in SNA Formats.")
appcHistSessSenseData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 8), SnaSenseData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistSessSenseData.setDescription("The sense data associated with the termination of the\nsession, taken from the negative BIND response or UNBIND\nrequest.")
appcHistSessComponentId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 9), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistSessComponentId.setDescription("The implementation-specific name of the component which\ndetected the problem.")
appcHistSessDetectModule = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 3, 1, 10), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistSessDetectModule.setDescription("The implementation-specific name of the module which\ndetected the problem.")
appcSessRtpTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 4))
if mibBuilder.loadTexts: appcSessRtpTable.setDescription("A table indicating how many APPC sessions terminating in this\nnode are transported by each RTP connection.")
appcSessRtpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 4, 1)).setIndexNames((0, "APPC-MIB", "appcSessRtpNceId"), (0, "APPC-MIB", "appcSessRtpTcid"))
if mibBuilder.loadTexts: appcSessRtpEntry.setDescription("Entry of APPC session RTP table.")
appcSessRtpNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 4, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcSessRtpNceId.setDescription("The local Network Connection Endpoint of the RTP connection.")
appcSessRtpTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 4, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcSessRtpTcid.setDescription("The local TCID of the RTP connection.")
appcSessRtpSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 4, 4, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcSessRtpSessions.setDescription("The number of APPC sessions terminating in this node\nthat are using this RTP connection.")
appcConversation = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 5))
appcActiveConvTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1))
if mibBuilder.loadTexts: appcActiveConvTable.setDescription("Table of information about active APPC Conversations.  In this\ncontext 'active' means that a conversation is currently\nassociated with a particular session.  Two entries are present\nin the table when both LUs for the session are local.")
appcActiveConvEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1)).setIndexNames((0, "APPC-MIB", "appcActiveConvLocLuName"), (0, "APPC-MIB", "appcActiveConvParLuName"), (0, "APPC-MIB", "appcActiveConvSessIndex"))
if mibBuilder.loadTexts: appcActiveConvEntry.setDescription("Entry representing one active APPC Conversation.")
appcActiveConvLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcActiveConvLocLuName.setDescription("The SNA name of the local LU for the conversation.  This field\nis from 1 to 17 characters in length, including a period (.)\nwhich separates the NetId from the NAU name if the NetId is\npresent.\n\nIf this object has the same value as appcLluOperName,\nthen the two entries being indexed apply to the same\nresource (specifically, to the same local LU).")
appcActiveConvParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcActiveConvParLuName.setDescription("The SNA name of the partner LU for the conversation.  This\nfield is from 1 to 17 characters in length, including a period\n(.) which separates the NetId from the NAU name if the NetId is\npresent.\n\nIf this object has the same value as appcLuPairOperParLuName,\nthen the two entries being indexed apply to the same\nresource (specifically, to the same partner LU).")
appcActiveConvSessIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 3), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcActiveConvSessIndex.setDescription("Index of entry in appcActSessTable that is associated with\nthis conversation.  If this object has the same value as\nappcActSessIndex for the same LU pair, then the two entries\nbeing indexed apply to the same resource (specifically, to the\nsame session).")
appcActiveConvId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4, 4)).setFixedLength(4)).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvId.setDescription("The 4-byte ID of the conversation.")
appcActiveConvState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,5,9,13,7,10,3,4,2,14,17,11,12,16,8,15,6,)).subtype(namedValues=NamedValues(("reset", 1), ("sendOnly", 10), ("receiveOnly", 11), ("deferReceive", 12), ("deferDeallocate", 13), ("syncpoint", 14), ("syncpointSend", 15), ("syncpointDeallocate", 16), ("backoutRequired", 17), ("send", 2), ("receive", 3), ("confirm", 4), ("confirmSend", 5), ("confirmDealloc", 6), ("pendingDeallocate", 7), ("pendingPost", 8), ("sendReceive", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvState.setDescription("Indicates the state of the conversation at the instant when\nthe information was retrieved.  The values are:\n    reset\n              The conversation is reset (i.e., deallocated).\n    send\n              The conversation can send data.  This value also\n              is returned if the conversation is in\n              Send-Pending state.\n    receive\n              The conversation can receive data.\n    confirm\n              The conversation has received a confirm\n              indicator.  It can issue an [MC_]CONFIRMED or\n              [MC_]SEND_ERROR verb to change state.  It will\n              continue in Receive state if an [MC_]CONFIRMED\n              verb is issued.\n    confirmSend\n              The conversation is in Confirm state and changes\n              to Send state when an [MC_]CONFIRMED verb is\n              issued.\n    confirmDealloc\n              The conversation is in Confirm state and becomes\n              inactive when an [MC_]CONFIRMED verb is issued.\n    pendingDeallocate\n              The conversation is in Pending-Deallocate state\n              while it waits for (MC_)DEALLOCATE TYPE\n              (sync_level) to complete.\n    pendingPost\n              The conversation is in Pending-Post state while\n              it waits for the [MC_]RECEIVE_AND_POST verb to\n              complete its receive function.\n    sendReceive\n              The full-duplex conversation can send or receive\n              data.\n    sendOnly\n              The full-duplex conversation can send data, but\n              it does not have permission to receive data,\n              because the partner TP has already deallocated\n              its side of the conversation.\n    receiveOnly\n              The full-duplex conversation can receive data,\n              but it does not have permission to send data,\n              because it has already deallocated its side of\n              the conversation.\n    deferReceive\n              Waiting for a successful SYNCPT verb operation to\n              go into the receive state.\n    deferDeallocate\n              Waiting for a successful SYNCPT verb operation to\n              go into the reset state.\n    syncpoint\n              Need to response to a SYNCPT verb issued.  After\n              successful operation, the next state will be\n              receive.\n    syncpointSend\n              Need to response to a SYNCPT verb issued.  After\n              successful operation, the next state will be\n              send.\n    syncpointDeallocate\n              Need to response to a SYNCPT verb issued.  After\n              successful operation, the next state will be\n              reset.\n    backoutRequired\n              TP must execute a BACKOUT verb to backout the\n              transaction.")
appcActiveConvType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("basic", 1), ("mapped", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvType.setDescription("Indicates the type of conversation.  The values are:\n\nbasic\n          Indicates that this conversation supports\n          basic verbs.\n\nmapped\n          Indicates that this conversation supports\n          mapped verbs.")
appcActiveConvCorrelator = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvCorrelator.setDescription("This is an 8-byte identifier that the source LU assigns to the\nconversation; the source LU is the one that sent the allocation\nrequest.  The conversation correlator is included on the\nallocation request.  The conversation correlator uniquely\nidentifies a conversation, from among all conversations,\nbetween the local and partner LUs.  It may be used, for\nexample, during problem determination associated with a\nconversation.  A length of 0 indicates that no conversation\ncorrelator is defined.")
appcActiveConvSyncLvl = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("none", 1), ("confirm", 2), ("syncpt", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvSyncLvl.setDescription("Indicates the highest sync level support for the conversation.\nThe values are:\n\n      none\n              Indicates that no sync-level processing can be\n              performed on this conversation. The\n              transaction program does not issue verbs or\n              recognize any returned parameters\n              relating to any sync-level function.\n\n      confirm\n              Indicates that confirmation processing can be\n              performed on this conversation.  The\n              transaction program can issue verbs and\n              recognize returned parameters relating to\n              confirmation.\n\n      syncpt\n              Indicates that syncpt and confirmation processing\n              can be performed on this conversation. The\n              transaction program can issue verbs and recognize\n              returned parameters relating to syncpt and\n              confirmation.")
appcActiveConvSource = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("localLu", 1), ("partnerLu", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvSource.setDescription("Indicates whether the local or partner LU is the source of the\nconversation, that is, which LU started the conversation by\nsending the allocation request.\n\n     localLu\n              The local LU is the source of the conversation,\n              and the partner LU is the target of the\n              conversation.\n\n     partnerLu\n              The partner LU is the source of the\n              conversation, and the local LU is the target of\n              the conversation.")
appcActiveConvDuplex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("half", 1), ("full", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvDuplex.setDescription("Indicates the conversation duplex style in effect for the\nconversation.\n\n  half        Indicates that information can be transferred in\n              both directions, but only in one direction at a\n              time.\n\n  full        Indicates that information can be transferred in\n              both directions at the same time.")
appcActiveConvUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 11), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvUpTime.setDescription("The length of time since the conversation started, measured in\nhundredths of a second.")
appcActiveConvSendBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvSendBytes.setDescription("Indicates the number of bytes that was sent on the\nconversation.  The count includes all SNA RU bytes sent,\nincluding those in the FMH-5 (Attach), FMH-7 (Error\nDescription), SIGNAL, LUSTAT, and SNA responses; it does not\ninclude SNA TH and RH bytes.")
appcActiveConvRcvBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvRcvBytes.setDescription("Indicates the number of bytes that was received on the\nconversation.  The count includes all SNA RU bytes sent,\nincluding those in the FMH-5 (Attach), FMH-7 (Error\nDescription), SIGNAL, LUSTAT, and SNA responses; it does not\ninclude SNA TH and RH bytes.")
appcActiveConvUserid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 14), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvUserid.setDescription("The user ID that the initiating program provided in the\nincoming attach.")
appcActiveConvPcidNauName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 15), DisplayString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,17),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvPcidNauName.setDescription("The network-qualified NAU name of the\nnode at which the session and PCID originated.  For APPN\nand LEN nodes, this is either CP name of the APPN node at\nwhich the origin LU is located or the CP name of the\nNN serving the LEN node at which the origin LU is\nlocated.  This field is from 3 to 17 characters in\nlength, including a period (.) which separates the\nNetId from the NAU name.  A null string indicates\nthat the value is unknown.")
appcActiveConvPcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 16), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(8,8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvPcid.setDescription("The procedure correlation identifier (PCID) of the session.\nIt is an 8-octet value assigned by the control point providing\nsession services for the primary LU.  A null string indicates\nthat the value is unknown.")
appcActiveConvModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 17), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvModeName.setDescription("The Mode Name used for this conversation.\nThis is a 1-8 character name.")
appcActiveConvLuwIdName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 18), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvLuwIdName.setDescription("The SNA name of the LU that initiated the logical unit of work\nthat is associated with this active TP. This field is from\n1 to 17 characters in length, including a period (.) which\nseparates the NetId from the LU name if the NetId is present.")
appcActiveConvLuwIdInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 19), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 6))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvLuwIdInstance.setDescription("The instance identifier for the logical unit of work.")
appcActiveConvLuwIdSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 20), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 2))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvLuwIdSequence.setDescription("The sequence identifier for the logical unit of work.")
appcActiveConvTpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 1, 1, 21), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcActiveConvTpName.setDescription("The transaction program name which started this conversation.\nThis name could either be from a FMH5 ATTACH for a remotely\nstarted conversation, otherwise it could the name of the local\nTP if available.\n\nWhen the TP name consists entirely of displayable EBCDIC code\npoints, it is mapped directly to the equivalent ASCII display\nstring.  However, registered TP names always have a non-\ndisplayable EBCDIC code point (value less than or equal to\nx'3F') as the first character, so they cannot be directly\nmapped to an ASCII display string.  These TP names are\nconverted to a display string that is equivalent to a\nhexadecimal display of the EBCDIC code points.  For example,\nthe 2-byte TP name x'06F1' (CNOS) is converted to the 6-byte\nASCII display string '06F1' (including the two single quotes).\n\nThis name is NULL if the conversation is started locally\n(i.e., not with a FMH5 ATTACH).")
appcHistConvTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2))
if mibBuilder.loadTexts: appcHistConvTable.setDescription("Table of historical information about APPC Conversations that\nended in error.  Possible categories of error conditions that\ncould be saved in this table are:\n\n      - allocation errors,\n      - deallocate abend,\n      - program errors, and\n      - service errors.")
appcHistConvEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1)).setIndexNames((0, "APPC-MIB", "appcHistConvIndex"))
if mibBuilder.loadTexts: appcHistConvEntry.setDescription("Entry representing one APPC Conversation.")
appcHistConvIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 1), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcHistConvIndex.setDescription("Index for entry in Conversation table.  This value identifies\nthe unique index of the conversation.  It is recommended that\nan Agent not reuse the index of a deactivated conversation for\na significant period of time (e.g. one week).")
appcHistConvEndTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistConvEndTime.setDescription("The time at which the conversation ended.")
appcHistConvLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistConvLocLuName.setDescription("The name of the local LU for this conversation.  This field is\nfrom 1 to 17 characters in length, including a period (.) which\nseparates the NetId from the NAU name if the NetId is present.")
appcHistConvParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistConvParLuName.setDescription("The SNA name of the partner LU for the conversation.  This\nfield is from 1 to 17 characters in length, including a period\n(.) which separates the NetId from the NAU name if the NetId is\npresent.")
appcHistConvTpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistConvTpName.setDescription("The transaction program name which started this conversation.\nThis name could either be from a FMH5 ATTACH for a remotely\nstarted conversation, otherwise it could the name of the local\nTP if available.\n\nWhen the TP name consists entirely of displayable EBCDIC code\npoints, it is mapped directly to the equivalent ASCII display\nstring.  However, registered TP names always have a non-\ndisplayable EBCDIC code point (value less than or equal to\nx'3F') as the first character, so they cannot be directly\nmapped to an ASCII display string.  These TP names are\nconverted to a display string that is equivalent to a\nhexadecimal display of the EBCDIC code points.  For example,\nthe 2-byte TP name x'06F1' (CNOS) is converted to the 6-byte\nASCII display string '06F1' (including the two single quotes).\n\nThis name is NULL if the conversation is started locally\n(i.e., not with a FMH5 ATTACH).")
appcHistConvPcidNauName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 6), DisplayString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,17),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistConvPcidNauName.setDescription("The network-qualified NAU name of the\nnode at which the session and PCID originated.  For APPN\nand LEN nodes, this is either CP name of the APPN node at\nwhich the origin LU is located or the CP name of the\nNN serving the LEN node at which the origin LU is\nlocated.  This field is from 3 to 17 characters in\nlength, including a period (.) which separates the\nNetId from the NAU name.  A null string indicates that the\nvalue is unknown.")
appcHistConvPcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 7), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(8,8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistConvPcid.setDescription("The procedure correlation identifier (PCID) of the session.\nIt is an 8-octet value assigned by the control point providing\nsession services for the primary LU.  A null string indicates\nthat the value is unknown.")
appcHistConvSenseData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 8), SnaSenseData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistConvSenseData.setDescription("The sense data associated with the action that ended this\nconversation, e.g., FMH-7 or UNBIND.")
appcHistConvLogData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistConvLogData.setDescription("The first 32 bytes of the data portion of the Log Data GDS\nVariable that is associated with the last FMH-7 that occurred\non this conversation.  If there was no Log Data GDS Variable\nassociated with the FMH-7, this object is null.\n\nThis object reflects only the data portion of the Log Data\nGDS Variable (i.e. not the LL or GDS Id).")
appcHistConvEndedBy = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 5, 2, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("localLu", 1), ("partnerLu", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcHistConvEndedBy.setDescription("Indicates which LU ended the conversation.")
appcCPIC = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 1, 6))
appcCpicAdminTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1))
if mibBuilder.loadTexts: appcCpicAdminTable.setDescription("APPC CPI-C side information table.")
appcCpicAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1)).setIndexNames((0, "APPC-MIB", "appcCpicAdminLocLuName"), (0, "APPC-MIB", "appcCpicAdminSymbDestName"))
if mibBuilder.loadTexts: appcCpicAdminEntry.setDescription("Entry of APPC CPI-C side information Table.")
appcCpicAdminLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcCpicAdminLocLuName.setDescription("The SNA name of the local LU to which this CPI-C side\ninformation definition applies.  This field is from 1 to 17\ncharacters in length, including a period (.) which separates\nthe NetId from the NAU name if the NetId is present.\n\nThe reserved value '*ALL' indicates that the definition applies\nto all local LUs, and not just to a single local LU.")
appcCpicAdminSymbDestName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcCpicAdminSymbDestName.setDescription("Specifies the symbolic destination name used by CPI-C\napplications to identify this definition.")
appcCpicAdminParLuAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicAdminParLuAlias.setDescription("A local alias for the partner LU.  If not known or\nnot applicable, this object contains a zero-length\nstring.")
appcCpicAdminParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicAdminParLuName.setDescription("The SNA name of the partner LU.  This field is from 1 to 17\ncharacters in length, including a period (.)  which separates\nthe NetId from the NAU name if the NetId is present.")
appcCpicAdminModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicAdminModeName.setDescription("Specifies the mode name.  A mode defines the characteristics\nfor a group of sessions.  The mode name can be blank (8 space\ncharacters).")
appcCpicAdminTpNameType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("normal", 1), ("snaServiceTp", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicAdminTpNameType.setDescription("Specifies whether the TP name in appcCpicAdminTpName\nidentifies a normal TP or an SNA service TP.  In this context,\na normal TP is one with a name consisting only of displayable\ncharacters, while an SNA service TP has a name containing\noctets that do not map to displayable characters.")
appcCpicAdminTpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1, 7), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicAdminTpName.setDescription("Specifies the name of the partner TP to be used when a CPI-C\napplication initiates a conversation specifying this side\ninformation entry.\n\nDisplay convention\n\n   When the TP name consists entirely of displayable EBCDIC\n   code points, it is mapped directly to the equivalent ASCII\n   display string.  However, registered TP names always have a\n   non-displayable EBCDIC code point (value less than or equal\n   to x'3F') as the first character, so they cannot be\n   directly mapped to an ASCII display string.  These TP names\n   are converted to a display string that is equivalent to a\n   hexadecimal display of the EBCDIC code points.  For\n   example, the 2-byte TP name x'06F1' (CNOS) is converted to\n   the 6-byte ASCII display string '06F1' (including the two\n   single quotes).")
appcCpicAdminUserid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1, 8), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicAdminUserid.setDescription("The security userid, if any, associated with the side\ninformation definition.")
appcCpicAdminSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 1, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,3,5,6,2,)).subtype(namedValues=NamedValues(("none", 1), ("same", 2), ("pgm", 3), ("pgmStrong", 4), ("distributed", 5), ("mutual", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicAdminSecurity.setDescription("Specifies the security information to be used for allocating\nthe conversation.\n  none        - No security information.\n  same        - Use the security environment currently\n                associated with this TP.\n  pgm         - Use the program-supplied user_id and password.\n  pgmStrong   - Use the program-supplied user_id and password.\n                The local LU will insure that the password is\n                not exposed in clear-text form on the physical\n                network.\n  distributed - Use the security environment and a distributed\n                security system to generate the authentication\n                information for this request.  If distributed\n                security tokens cannot be generated, then fail\n                the conversation.\n  mutual      - Authenticate both the user to the destination\n                system and the destination system to the user.")
appcCpicOperTable = MibTable((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2))
if mibBuilder.loadTexts: appcCpicOperTable.setDescription("APPC CPI-C side information operational table.")
appcCpicOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1)).setIndexNames((0, "APPC-MIB", "appcCpicOperLocLuName"), (0, "APPC-MIB", "appcCpicOperSymbDestName"))
if mibBuilder.loadTexts: appcCpicOperEntry.setDescription("Entry of APPC CPI-C side information Table.")
appcCpicOperLocLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcCpicOperLocLuName.setDescription("The SNA name of the local LU to which this CPI-C side\ninformation definition applies.  This field is from 1 to 17\ncharacters in length, including a period (.) which separates\nthe NetId from the NAU name if the NetId is present.\n\nThe reserved value '*ALL' indicates that the definition applies\nto all local LUs, and not just to a single local LU.")
appcCpicOperSymbDestName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appcCpicOperSymbDestName.setDescription("Specifies the symbolic destination name used by CPI-C\napplications to identify this definition.")
appcCpicOperParLuAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicOperParLuAlias.setDescription("A local alias for the partner LU.  If not known or not\napplicable, this object contains a zero-length string.")
appcCpicOperParLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicOperParLuName.setDescription("The SNA name of the partner LU.  This field is from 1 to 17\ncharacters in length, including a period (.) which separates\nthe NetId from the NAU name if the NetId is present.")
appcCpicOperModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicOperModeName.setDescription("Specifies the mode name.  A mode defines the characteristics\nfor a group of sessions.  The mode name can be blank (8 space\ncharacters).")
appcCpicOperTpNameType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("normal", 1), ("snaServiceTp", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicOperTpNameType.setDescription("Specifies whether the TP name in appcCpicOperTpName identifies\na normal TP or an SNA service TP.  In this context, a normal TP\nis one with a name consisting only of displayable characters,\nwhile an SNA service TP has a name containing octets that do\nnot map to displayable characters.")
appcCpicOperTpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1, 7), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicOperTpName.setDescription("Specifies the name of the partner TP to be used when a CPI-C\napplication initiates a conversation specifying this side\ninformation entry.\nDisplay convention\n\n    When the TP name consists entirely of displayable EBCDIC\n    code points, it is mapped directly to the equivalent ASCII\n    display string.  However, registered TP names always have\n    a non-displayable EBCDIC code point (value less than or\n    equal to x'3F') as the first character, so they cannot be\n    directly mapped to an ASCII display string.  These TP\n    names are converted to a display string that is equivalent\n    to a hexadecimal display of the EBCDIC code points.  For\n    example, the 2-byte TP name x'06F1' (CNOS) is converted to\n    the 6-byte ASCII display string '06F1' (including the two\n    single quotes).")
appcCpicOperUserid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1, 8), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicOperUserid.setDescription("The security userid, if any, associated with the active side\ninformation definition.")
appcCpicOperSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 3, 1, 6, 2, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,3,5,6,2,)).subtype(namedValues=NamedValues(("none", 1), ("same", 2), ("pgm", 3), ("pgmStrong", 4), ("distributed", 5), ("mutual", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appcCpicOperSecurity.setDescription("Specifies the security information to be used for allocating\nthe conversation.\n\n  none        - No security information.\n  same        - Use the security environment currently\n                associated with this TP.\n  pgm         - Use the program-supplied user_id and password.\n  pgmStrong   - Use the program-supplied user_id and password.\n                The local LU will insure that the password is\n                not exposed in clear-text form on the physical\n                network.\n  distributed - Use the security environment and a distributed\n                security system to generate the authentication\n                information for this request.  If distributed\n                security tokens cannot be generated, then fail\n                the conversation.\n  mutual      - Authenticate both the user to the destination\n                system and the destination system to the user.")
appcConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 2))
appcCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 2, 1))
appcGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 3, 2, 2))

# Augmentions

# Groups

appcGlobalConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 1)).setObjects(*(("APPC-MIB", "appcActiveSessions"), ("APPC-MIB", "appcDefaultTpOperation"), ("APPC-MIB", "appcLocalCpName"), ("APPC-MIB", "appcDefaultModeName"), ("APPC-MIB", "appcUpTime"), ("APPC-MIB", "appcDefaultTpConvSecRqd"), ("APPC-MIB", "appcDefaultImplInbndPlu"), ("APPC-MIB", "appcDefaultFileSpec"), ("APPC-MIB", "appcActiveHprSessions"), ("APPC-MIB", "appcDefaultLuName"), ("APPC-MIB", "appcDefaultMaxMcLlSndSize"), ) )
if mibBuilder.loadTexts: appcGlobalConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\nglobal information and defaults.")
appcLluConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 2)).setObjects(*(("APPC-MIB", "appcLluOperOutBoundCompLevel"), ("APPC-MIB", "appcLluOperAlias"), ("APPC-MIB", "appcLluAdminBindRspMayQ"), ("APPC-MIB", "appcLluOperCompRleBeforeLZ"), ("APPC-MIB", "appcLluAdminDepType"), ("APPC-MIB", "appcLluOperCompression"), ("APPC-MIB", "appcLluOperLocalAddress"), ("APPC-MIB", "appcLluAdminCompression"), ("APPC-MIB", "appcLluOperActiveSessions"), ("APPC-MIB", "appcLluAdminCompRleBeforeLZ"), ("APPC-MIB", "appcLluOperSessLimit"), ("APPC-MIB", "appcLluOperDepType"), ("APPC-MIB", "appcLluOperBindRspMayQ"), ("APPC-MIB", "appcLluAdminSessLimit"), ("APPC-MIB", "appcLluAdminLocalAddress"), ("APPC-MIB", "appcLluAdminInBoundCompLevel"), ("APPC-MIB", "appcLluAdminAlias"), ("APPC-MIB", "appcLluOperInBoundCompLevel"), ("APPC-MIB", "appcLluAdminOutBoundCompLevel"), ) )
if mibBuilder.loadTexts: appcLluConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\nlocal LU6.2s.")
appcParLuConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 3)).setObjects(*(("APPC-MIB", "appcLuPairAdminSessLimit"), ("APPC-MIB", "appcLuPairAdminParLuAlias"), ("APPC-MIB", "appcLuPairOperParLuAlias"), ("APPC-MIB", "appcLuPairAdminSessSec"), ("APPC-MIB", "appcLuPairAdminLinkObjId"), ("APPC-MIB", "appcLuPairOperSessSec"), ("APPC-MIB", "appcLuPairOperLinkObjId"), ("APPC-MIB", "appcLuPairOperParaSessSupLS"), ("APPC-MIB", "appcLuPairOperSessLimit"), ("APPC-MIB", "appcLuPairAdminParaSessSup"), ("APPC-MIB", "appcLuPairAdminSecAccept"), ("APPC-MIB", "appcLuPairOperState"), ("APPC-MIB", "appcLuPairOperSecAccept"), ("APPC-MIB", "appcLuPairOperParaSessSup"), ) )
if mibBuilder.loadTexts: appcParLuConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\npartner LUs.")
appcModeConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 4)).setObjects(*(("APPC-MIB", "appcModeAdminPrefSendRuSz"), ("APPC-MIB", "appcModeOperRecvRuSzUpBnd"), ("APPC-MIB", "appcModeOperMinClosLimit"), ("APPC-MIB", "appcModeAdminRecvRuSzUpBnd"), ("APPC-MIB", "appcModeAdminMinClosLimit"), ("APPC-MIB", "appcModeOperPrefSendRuSz"), ("APPC-MIB", "appcModeAdminCompRleBeforeLZ"), ("APPC-MIB", "appcModeOperActCwin"), ("APPC-MIB", "appcModeOperInBoundCompLevel"), ("APPC-MIB", "appcModeOperSendPacWinSz"), ("APPC-MIB", "appcModeOperConWinAutoActLmt"), ("APPC-MIB", "appcModeOperCrypto"), ("APPC-MIB", "appcModeAdminCrypto"), ("APPC-MIB", "appcModeOperSingSessReinit"), ("APPC-MIB", "appcModeOperSessLimit"), ("APPC-MIB", "appcModeAdminCosName"), ("APPC-MIB", "appcModeAdminSendRuSzLoBnd"), ("APPC-MIB", "appcModeAdminCompression"), ("APPC-MIB", "appcModeOperSendRuSzLoBnd"), ("APPC-MIB", "appcModeOperOutBoundCompLevel"), ("APPC-MIB", "appcModeAdminInBoundCompLevel"), ("APPC-MIB", "appcModeAdminMaxSessLimit"), ("APPC-MIB", "appcModeOperPndClos"), ("APPC-MIB", "appcModeOperPtmCwin"), ("APPC-MIB", "appcModeAdminRecvPacWinSz"), ("APPC-MIB", "appcModeAdminSyncLvl"), ("APPC-MIB", "appcModeOperRecvPacWinSz"), ("APPC-MIB", "appcModeOperSessEndTpName"), ("APPC-MIB", "appcModeAdminPrefRecvRuSz"), ("APPC-MIB", "appcModeOperPtmClos"), ("APPC-MIB", "appcModeOperMaxSessLimit"), ("APPC-MIB", "appcModeOperCompression"), ("APPC-MIB", "appcModeOperCompRleBeforeLZ"), ("APPC-MIB", "appcModeOperPrefRecvRuSz"), ("APPC-MIB", "appcModeOperRecvRuSzLoBnd"), ("APPC-MIB", "appcModeOperPndCwin"), ("APPC-MIB", "appcModeAdminSendPacWinSz"), ("APPC-MIB", "appcModeAdminRecvRuSzLoBnd"), ("APPC-MIB", "appcModeOperCryptoLastStart"), ("APPC-MIB", "appcModeAdminSendRuSzUpBnd"), ("APPC-MIB", "appcModeOperCosName"), ("APPC-MIB", "appcModeOperDrainSelf"), ("APPC-MIB", "appcModeOperDrainPart"), ("APPC-MIB", "appcModeAdminOutBoundCompLevel"), ("APPC-MIB", "appcModeAdminSessEndTpName"), ("APPC-MIB", "appcModeOperSyncLvlLastStart"), ("APPC-MIB", "appcModeAdminConWinAutoActLmt"), ("APPC-MIB", "appcModeOperCNOSNeg"), ("APPC-MIB", "appcModeOperSendRuSzUpBnd"), ("APPC-MIB", "appcModeOperMinCwinLimit"), ("APPC-MIB", "appcModeOperActClos"), ("APPC-MIB", "appcModeOperSyncLvl"), ("APPC-MIB", "appcModeAdminMinCwinLimit"), ("APPC-MIB", "appcModeAdminSingSessReinit"), ) )
if mibBuilder.loadTexts: appcModeConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\nmodes.")
appcTpConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 5)).setObjects(*(("APPC-MIB", "appcTpAdminInAttachTimeout"), ("APPC-MIB", "appcTpAdminSyncLvl"), ("APPC-MIB", "appcTpAdminStatus"), ("APPC-MIB", "appcTpAdminVerPip"), ("APPC-MIB", "appcTpAdminRcvAllocTimeout"), ("APPC-MIB", "appcTpAdminTpOperation"), ("APPC-MIB", "appcTpAdminLongRun"), ("APPC-MIB", "appcTpAdminStartParm"), ("APPC-MIB", "appcTpAdminConvSecReq"), ("APPC-MIB", "appcTpAdminFileSpec"), ("APPC-MIB", "appcTpAdminInstLmt"), ("APPC-MIB", "appcTpAdminConvType"), ("APPC-MIB", "appcTpAdminPipSubNum"), ("APPC-MIB", "appcTpAdminConvDuplex"), ) )
if mibBuilder.loadTexts: appcTpConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\nTransaction Programs.")
appcSessionConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 6)).setObjects(*(("APPC-MIB", "appcActSessMaxRcvRuSize"), ("APPC-MIB", "appcActSessRcvPacingSize"), ("APPC-MIB", "appcActSessCosName"), ("APPC-MIB", "appcActSessPcid"), ("APPC-MIB", "appcActSessRecvPacingType"), ("APPC-MIB", "appcActSessRscv"), ("APPC-MIB", "appcActSessSendPacingType"), ("APPC-MIB", "appcSessStatsSentNonFmdBytes"), ("APPC-MIB", "appcSessStatsRcvdFmdBytes"), ("APPC-MIB", "appcSessStatsRcvdNonFmdBytes"), ("APPC-MIB", "appcActSessInUse"), ("APPC-MIB", "appcActSessSndPacingSize"), ("APPC-MIB", "appcActSessUpTime"), ("APPC-MIB", "appcActSessRtpNceId"), ("APPC-MIB", "appcActSessRecvRpc"), ("APPC-MIB", "appcHistSessDetectModule"), ("APPC-MIB", "appcActSessSendRpc"), ("APPC-MIB", "appcSessStatsSentFmdBytes"), ("APPC-MIB", "appcActSessOperState"), ("APPC-MIB", "appcActSessPcidCpName"), ("APPC-MIB", "appcActSessRecvNxWndwSize"), ("APPC-MIB", "appcActSessEnhanceSecSup"), ("APPC-MIB", "appcActSessPluIndicator"), ("APPC-MIB", "appcHistSessLocLuName"), ("APPC-MIB", "appcActSessRtpTcid"), ("APPC-MIB", "appcHistSessType"), ("APPC-MIB", "appcActSessTransPriority"), ("APPC-MIB", "appcSessStatsSentFmdRus"), ("APPC-MIB", "appcSessRtpSessions"), ("APPC-MIB", "appcActSessLinkIndex"), ("APPC-MIB", "appcSessStatsCtrUpTime"), ("APPC-MIB", "appcHistSessTime"), ("APPC-MIB", "appcActSessMaxSndRuSize"), ("APPC-MIB", "appcHistSessComponentId"), ("APPC-MIB", "appcActSessModeName"), ("APPC-MIB", "appcHistSessUnbindType"), ("APPC-MIB", "appcHistSessSenseData"), ("APPC-MIB", "appcSessStatsRcvdFmdRus"), ("APPC-MIB", "appcActSessSendNxWndwSize"), ("APPC-MIB", "appcHistSessModeName"), ("APPC-MIB", "appcSessStatsSentNonFmdRus"), ("APPC-MIB", "appcSessStatsRcvdNonFmdRus"), ("APPC-MIB", "appcHistSessParLuName"), ) )
if mibBuilder.loadTexts: appcSessionConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\nLU6.2 sessions.")
appcControlConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 7)).setObjects(*(("APPC-MIB", "appcCntrlOperTrace"), ("APPC-MIB", "appcCntrlOperStat"), ("APPC-MIB", "appcCntrlOperStatTime"), ("APPC-MIB", "appcCntrlOperTraceTime"), ("APPC-MIB", "appcCntrlAdminTrace"), ("APPC-MIB", "appcCntrlAdminStat"), ("APPC-MIB", "appcCntrlAdminTraceParm"), ("APPC-MIB", "appcCntrlAdminRscv"), ("APPC-MIB", "appcCntrlOperRscvTime"), ("APPC-MIB", "appcCntrlOperTraceParm"), ("APPC-MIB", "appcCntrlOperRscv"), ) )
if mibBuilder.loadTexts: appcControlConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\ncontrol.")
appcCnosConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 8)).setObjects(*(("APPC-MIB", "appcCnosTargetModeName"), ("APPC-MIB", "appcCnosTargetParLuName"), ("APPC-MIB", "appcCnosMaxSessLimit"), ("APPC-MIB", "appcCnosCommand"), ("APPC-MIB", "appcCnosForce"), ("APPC-MIB", "appcCnosTargetLocLuName"), ("APPC-MIB", "appcCnosMinClosLimit"), ("APPC-MIB", "appcCnosDrainPart"), ("APPC-MIB", "appcCnosResponsible"), ("APPC-MIB", "appcCnosDrainSelf"), ("APPC-MIB", "appcCnosMinCwinLimit"), ) )
if mibBuilder.loadTexts: appcCnosConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\nCNOS processing.")
appcCpicConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 9)).setObjects(*(("APPC-MIB", "appcCpicAdminParLuName"), ("APPC-MIB", "appcCpicOperSecurity"), ("APPC-MIB", "appcCpicAdminTpNameType"), ("APPC-MIB", "appcCpicOperModeName"), ("APPC-MIB", "appcCpicOperParLuName"), ("APPC-MIB", "appcCpicAdminUserid"), ("APPC-MIB", "appcCpicOperUserid"), ("APPC-MIB", "appcCpicAdminSecurity"), ("APPC-MIB", "appcCpicAdminTpName"), ("APPC-MIB", "appcCpicOperTpName"), ("APPC-MIB", "appcCpicAdminModeName"), ("APPC-MIB", "appcCpicAdminParLuAlias"), ("APPC-MIB", "appcCpicOperParLuAlias"), ("APPC-MIB", "appcCpicOperTpNameType"), ) )
if mibBuilder.loadTexts: appcCpicConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\nCPI-C side information.")
appcConversationConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 3, 2, 2, 10)).setObjects(*(("APPC-MIB", "appcActiveConvUserid"), ("APPC-MIB", "appcActiveConvLuwIdSequence"), ("APPC-MIB", "appcActiveConvTpName"), ("APPC-MIB", "appcHistConvEndedBy"), ("APPC-MIB", "appcActiveConvState"), ("APPC-MIB", "appcHistConvSenseData"), ("APPC-MIB", "appcHistConvParLuName"), ("APPC-MIB", "appcActiveConvLuwIdName"), ("APPC-MIB", "appcActiveConvDuplex"), ("APPC-MIB", "appcHistConvPcid"), ("APPC-MIB", "appcHistConvEndTime"), ("APPC-MIB", "appcActiveConvPcidNauName"), ("APPC-MIB", "appcActiveConvSyncLvl"), ("APPC-MIB", "appcActiveConvLuwIdInstance"), ("APPC-MIB", "appcActiveConvSource"), ("APPC-MIB", "appcActiveConvPcid"), ("APPC-MIB", "appcActiveConvType"), ("APPC-MIB", "appcHistConvLogData"), ("APPC-MIB", "appcActiveConvSendBytes"), ("APPC-MIB", "appcActiveConvUpTime"), ("APPC-MIB", "appcHistConvPcidNauName"), ("APPC-MIB", "appcActiveConvRcvBytes"), ("APPC-MIB", "appcHistConvTpName"), ("APPC-MIB", "appcActiveConvModeName"), ("APPC-MIB", "appcActiveConvId"), ("APPC-MIB", "appcHistConvLocLuName"), ("APPC-MIB", "appcActiveConvCorrelator"), ) )
if mibBuilder.loadTexts: appcConversationConfGroup.setDescription("A collection of objects providing the instrumentation of APPC\nconversations.")

# Compliances

appcCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 34, 3, 2, 1, 1)).setObjects(*(("APPC-MIB", "appcTpConfGroup"), ("APPC-MIB", "appcParLuConfGroup"), ("APPC-MIB", "appcSessionConfGroup"), ("APPC-MIB", "appcModeConfGroup"), ("APPC-MIB", "appcControlConfGroup"), ("APPC-MIB", "appcCpicConfGroup"), ("APPC-MIB", "appcLluConfGroup"), ("APPC-MIB", "appcCnosConfGroup"), ("APPC-MIB", "appcGlobalConfGroup"), ("APPC-MIB", "appcConversationConfGroup"), ) )
if mibBuilder.loadTexts: appcCompliance.setDescription("The compliance statement for the SNMPv2 entities which\nimplement the APPC MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("APPC-MIB", PYSNMP_MODULE_ID=appcMIB)

# Types
mibBuilder.exportSymbols("APPC-MIB", SnaSenseData=SnaSenseData)

# Objects
mibBuilder.exportSymbols("APPC-MIB", appcMIB=appcMIB, appcObjects=appcObjects, appcGlobal=appcGlobal, appcCntrlAdminGroup=appcCntrlAdminGroup, appcCntrlAdminStat=appcCntrlAdminStat, appcCntrlAdminRscv=appcCntrlAdminRscv, appcCntrlAdminTrace=appcCntrlAdminTrace, appcCntrlAdminTraceParm=appcCntrlAdminTraceParm, appcCntrlOperGroup=appcCntrlOperGroup, appcCntrlOperStat=appcCntrlOperStat, appcCntrlOperStatTime=appcCntrlOperStatTime, appcCntrlOperRscv=appcCntrlOperRscv, appcCntrlOperRscvTime=appcCntrlOperRscvTime, appcCntrlOperTrace=appcCntrlOperTrace, appcCntrlOperTraceTime=appcCntrlOperTraceTime, appcCntrlOperTraceParm=appcCntrlOperTraceParm, appcGlobalObjects=appcGlobalObjects, appcUpTime=appcUpTime, appcDefaultModeName=appcDefaultModeName, appcDefaultLuName=appcDefaultLuName, appcDefaultImplInbndPlu=appcDefaultImplInbndPlu, appcDefaultMaxMcLlSndSize=appcDefaultMaxMcLlSndSize, appcDefaultFileSpec=appcDefaultFileSpec, appcDefaultTpOperation=appcDefaultTpOperation, appcDefaultTpConvSecRqd=appcDefaultTpConvSecRqd, appcLocalCpName=appcLocalCpName, appcActiveSessions=appcActiveSessions, appcActiveHprSessions=appcActiveHprSessions, appcCnosControl=appcCnosControl, appcCnosCommand=appcCnosCommand, appcCnosMaxSessLimit=appcCnosMaxSessLimit, appcCnosMinCwinLimit=appcCnosMinCwinLimit, appcCnosMinClosLimit=appcCnosMinClosLimit, appcCnosDrainSelf=appcCnosDrainSelf, appcCnosDrainPart=appcCnosDrainPart, appcCnosResponsible=appcCnosResponsible, appcCnosForce=appcCnosForce, appcCnosTargetLocLuName=appcCnosTargetLocLuName, appcCnosTargetParLuName=appcCnosTargetParLuName, appcCnosTargetModeName=appcCnosTargetModeName, appcLu=appcLu, appcLluAdminTable=appcLluAdminTable, appcLluAdminEntry=appcLluAdminEntry, appcLluAdminName=appcLluAdminName, appcLluAdminDepType=appcLluAdminDepType, appcLluAdminLocalAddress=appcLluAdminLocalAddress, appcLluAdminSessLimit=appcLluAdminSessLimit, appcLluAdminBindRspMayQ=appcLluAdminBindRspMayQ, appcLluAdminCompression=appcLluAdminCompression, appcLluAdminInBoundCompLevel=appcLluAdminInBoundCompLevel, appcLluAdminOutBoundCompLevel=appcLluAdminOutBoundCompLevel, appcLluAdminCompRleBeforeLZ=appcLluAdminCompRleBeforeLZ, appcLluAdminAlias=appcLluAdminAlias, appcLluOperTable=appcLluOperTable, appcLluOperEntry=appcLluOperEntry, appcLluOperName=appcLluOperName, appcLluOperDepType=appcLluOperDepType, appcLluOperLocalAddress=appcLluOperLocalAddress, appcLluOperSessLimit=appcLluOperSessLimit, appcLluOperBindRspMayQ=appcLluOperBindRspMayQ, appcLluOperCompression=appcLluOperCompression, appcLluOperInBoundCompLevel=appcLluOperInBoundCompLevel, appcLluOperOutBoundCompLevel=appcLluOperOutBoundCompLevel, appcLluOperCompRleBeforeLZ=appcLluOperCompRleBeforeLZ, appcLluOperAlias=appcLluOperAlias, appcLluOperActiveSessions=appcLluOperActiveSessions, appcLuPairAdminTable=appcLuPairAdminTable, appcLuPairAdminEntry=appcLuPairAdminEntry, appcLuPairAdminLocLuName=appcLuPairAdminLocLuName, appcLuPairAdminParLuName=appcLuPairAdminParLuName, appcLuPairAdminParLuAlias=appcLuPairAdminParLuAlias, appcLuPairAdminSessLimit=appcLuPairAdminSessLimit, appcLuPairAdminSessSec=appcLuPairAdminSessSec, appcLuPairAdminSecAccept=appcLuPairAdminSecAccept, appcLuPairAdminLinkObjId=appcLuPairAdminLinkObjId, appcLuPairAdminParaSessSup=appcLuPairAdminParaSessSup, appcLuPairOperTable=appcLuPairOperTable, appcLuPairOperEntry=appcLuPairOperEntry, appcLuPairOperLocLuName=appcLuPairOperLocLuName, appcLuPairOperParLuName=appcLuPairOperParLuName, appcLuPairOperParLuAlias=appcLuPairOperParLuAlias, appcLuPairOperSessLimit=appcLuPairOperSessLimit, appcLuPairOperSessSec=appcLuPairOperSessSec, appcLuPairOperSecAccept=appcLuPairOperSecAccept, appcLuPairOperLinkObjId=appcLuPairOperLinkObjId, appcLuPairOperParaSessSup=appcLuPairOperParaSessSup, appcLuPairOperParaSessSupLS=appcLuPairOperParaSessSupLS, appcLuPairOperState=appcLuPairOperState, appcModeAdminTable=appcModeAdminTable, appcModeAdminEntry=appcModeAdminEntry, appcModeAdminLocLuName=appcModeAdminLocLuName, appcModeAdminParLuName=appcModeAdminParLuName, appcModeAdminModeName=appcModeAdminModeName, appcModeAdminCosName=appcModeAdminCosName, appcModeAdminSessEndTpName=appcModeAdminSessEndTpName, appcModeAdminMaxSessLimit=appcModeAdminMaxSessLimit, appcModeAdminMinCwinLimit=appcModeAdminMinCwinLimit, appcModeAdminMinClosLimit=appcModeAdminMinClosLimit, appcModeAdminConWinAutoActLmt=appcModeAdminConWinAutoActLmt, appcModeAdminRecvPacWinSz=appcModeAdminRecvPacWinSz, appcModeAdminSendPacWinSz=appcModeAdminSendPacWinSz, appcModeAdminPrefRecvRuSz=appcModeAdminPrefRecvRuSz, appcModeAdminPrefSendRuSz=appcModeAdminPrefSendRuSz, appcModeAdminRecvRuSzUpBnd=appcModeAdminRecvRuSzUpBnd, appcModeAdminSendRuSzUpBnd=appcModeAdminSendRuSzUpBnd, appcModeAdminRecvRuSzLoBnd=appcModeAdminRecvRuSzLoBnd, appcModeAdminSendRuSzLoBnd=appcModeAdminSendRuSzLoBnd, appcModeAdminSingSessReinit=appcModeAdminSingSessReinit, appcModeAdminCompression=appcModeAdminCompression, appcModeAdminInBoundCompLevel=appcModeAdminInBoundCompLevel, appcModeAdminOutBoundCompLevel=appcModeAdminOutBoundCompLevel, appcModeAdminCompRleBeforeLZ=appcModeAdminCompRleBeforeLZ, appcModeAdminSyncLvl=appcModeAdminSyncLvl, appcModeAdminCrypto=appcModeAdminCrypto, appcModeOperTable=appcModeOperTable, appcModeOperEntry=appcModeOperEntry, appcModeOperLocLuName=appcModeOperLocLuName, appcModeOperParLuName=appcModeOperParLuName, appcModeOperModeName=appcModeOperModeName, appcModeOperCosName=appcModeOperCosName, appcModeOperSessEndTpName=appcModeOperSessEndTpName, appcModeOperSessLimit=appcModeOperSessLimit, appcModeOperMaxSessLimit=appcModeOperMaxSessLimit, appcModeOperMinCwinLimit=appcModeOperMinCwinLimit, appcModeOperMinClosLimit=appcModeOperMinClosLimit, appcModeOperConWinAutoActLmt=appcModeOperConWinAutoActLmt)
mibBuilder.exportSymbols("APPC-MIB", appcModeOperRecvPacWinSz=appcModeOperRecvPacWinSz, appcModeOperSendPacWinSz=appcModeOperSendPacWinSz, appcModeOperPrefRecvRuSz=appcModeOperPrefRecvRuSz, appcModeOperPrefSendRuSz=appcModeOperPrefSendRuSz, appcModeOperRecvRuSzUpBnd=appcModeOperRecvRuSzUpBnd, appcModeOperSendRuSzUpBnd=appcModeOperSendRuSzUpBnd, appcModeOperRecvRuSzLoBnd=appcModeOperRecvRuSzLoBnd, appcModeOperSendRuSzLoBnd=appcModeOperSendRuSzLoBnd, appcModeOperSingSessReinit=appcModeOperSingSessReinit, appcModeOperCompression=appcModeOperCompression, appcModeOperInBoundCompLevel=appcModeOperInBoundCompLevel, appcModeOperOutBoundCompLevel=appcModeOperOutBoundCompLevel, appcModeOperCompRleBeforeLZ=appcModeOperCompRleBeforeLZ, appcModeOperSyncLvl=appcModeOperSyncLvl, appcModeOperCrypto=appcModeOperCrypto, appcModeOperSyncLvlLastStart=appcModeOperSyncLvlLastStart, appcModeOperCryptoLastStart=appcModeOperCryptoLastStart, appcModeOperCNOSNeg=appcModeOperCNOSNeg, appcModeOperActCwin=appcModeOperActCwin, appcModeOperActClos=appcModeOperActClos, appcModeOperPndCwin=appcModeOperPndCwin, appcModeOperPndClos=appcModeOperPndClos, appcModeOperPtmCwin=appcModeOperPtmCwin, appcModeOperPtmClos=appcModeOperPtmClos, appcModeOperDrainSelf=appcModeOperDrainSelf, appcModeOperDrainPart=appcModeOperDrainPart, appcTp=appcTp, appcTpAdminTable=appcTpAdminTable, appcTpAdminEntry=appcTpAdminEntry, appcTpAdminLocLuName=appcTpAdminLocLuName, appcTpAdminTpName=appcTpAdminTpName, appcTpAdminFileSpec=appcTpAdminFileSpec, appcTpAdminStartParm=appcTpAdminStartParm, appcTpAdminTpOperation=appcTpAdminTpOperation, appcTpAdminInAttachTimeout=appcTpAdminInAttachTimeout, appcTpAdminRcvAllocTimeout=appcTpAdminRcvAllocTimeout, appcTpAdminSyncLvl=appcTpAdminSyncLvl, appcTpAdminInstLmt=appcTpAdminInstLmt, appcTpAdminStatus=appcTpAdminStatus, appcTpAdminLongRun=appcTpAdminLongRun, appcTpAdminConvType=appcTpAdminConvType, appcTpAdminConvDuplex=appcTpAdminConvDuplex, appcTpAdminConvSecReq=appcTpAdminConvSecReq, appcTpAdminVerPip=appcTpAdminVerPip, appcTpAdminPipSubNum=appcTpAdminPipSubNum, appcSession=appcSession, appcActSessTable=appcActSessTable, appcActSessEntry=appcActSessEntry, appcActSessLocLuName=appcActSessLocLuName, appcActSessParLuName=appcActSessParLuName, appcActSessIndex=appcActSessIndex, appcActSessPcidCpName=appcActSessPcidCpName, appcActSessPcid=appcActSessPcid, appcActSessPluIndicator=appcActSessPluIndicator, appcActSessModeName=appcActSessModeName, appcActSessCosName=appcActSessCosName, appcActSessTransPriority=appcActSessTransPriority, appcActSessEnhanceSecSup=appcActSessEnhanceSecSup, appcActSessSendPacingType=appcActSessSendPacingType, appcActSessSendRpc=appcActSessSendRpc, appcActSessSendNxWndwSize=appcActSessSendNxWndwSize, appcActSessRecvPacingType=appcActSessRecvPacingType, appcActSessRecvRpc=appcActSessRecvRpc, appcActSessRecvNxWndwSize=appcActSessRecvNxWndwSize, appcActSessRscv=appcActSessRscv, appcActSessInUse=appcActSessInUse, appcActSessMaxSndRuSize=appcActSessMaxSndRuSize, appcActSessMaxRcvRuSize=appcActSessMaxRcvRuSize, appcActSessSndPacingSize=appcActSessSndPacingSize, appcActSessRcvPacingSize=appcActSessRcvPacingSize, appcActSessOperState=appcActSessOperState, appcActSessUpTime=appcActSessUpTime, appcActSessRtpNceId=appcActSessRtpNceId, appcActSessRtpTcid=appcActSessRtpTcid, appcActSessLinkIndex=appcActSessLinkIndex, appcSessStatsTable=appcSessStatsTable, appcSessStatsEntry=appcSessStatsEntry, appcSessStatsLocLuName=appcSessStatsLocLuName, appcSessStatsParLuName=appcSessStatsParLuName, appcSessStatsSessIndex=appcSessStatsSessIndex, appcSessStatsSentFmdBytes=appcSessStatsSentFmdBytes, appcSessStatsSentNonFmdBytes=appcSessStatsSentNonFmdBytes, appcSessStatsRcvdFmdBytes=appcSessStatsRcvdFmdBytes, appcSessStatsRcvdNonFmdBytes=appcSessStatsRcvdNonFmdBytes, appcSessStatsSentFmdRus=appcSessStatsSentFmdRus, appcSessStatsSentNonFmdRus=appcSessStatsSentNonFmdRus, appcSessStatsRcvdFmdRus=appcSessStatsRcvdFmdRus, appcSessStatsRcvdNonFmdRus=appcSessStatsRcvdNonFmdRus, appcSessStatsCtrUpTime=appcSessStatsCtrUpTime, appcHistSessTable=appcHistSessTable, appcHistSessEntry=appcHistSessEntry, appcHistSessIndex=appcHistSessIndex, appcHistSessTime=appcHistSessTime, appcHistSessType=appcHistSessType, appcHistSessLocLuName=appcHistSessLocLuName, appcHistSessParLuName=appcHistSessParLuName, appcHistSessModeName=appcHistSessModeName, appcHistSessUnbindType=appcHistSessUnbindType, appcHistSessSenseData=appcHistSessSenseData, appcHistSessComponentId=appcHistSessComponentId, appcHistSessDetectModule=appcHistSessDetectModule, appcSessRtpTable=appcSessRtpTable, appcSessRtpEntry=appcSessRtpEntry, appcSessRtpNceId=appcSessRtpNceId, appcSessRtpTcid=appcSessRtpTcid, appcSessRtpSessions=appcSessRtpSessions, appcConversation=appcConversation, appcActiveConvTable=appcActiveConvTable, appcActiveConvEntry=appcActiveConvEntry, appcActiveConvLocLuName=appcActiveConvLocLuName, appcActiveConvParLuName=appcActiveConvParLuName, appcActiveConvSessIndex=appcActiveConvSessIndex, appcActiveConvId=appcActiveConvId, appcActiveConvState=appcActiveConvState, appcActiveConvType=appcActiveConvType, appcActiveConvCorrelator=appcActiveConvCorrelator, appcActiveConvSyncLvl=appcActiveConvSyncLvl, appcActiveConvSource=appcActiveConvSource, appcActiveConvDuplex=appcActiveConvDuplex, appcActiveConvUpTime=appcActiveConvUpTime, appcActiveConvSendBytes=appcActiveConvSendBytes, appcActiveConvRcvBytes=appcActiveConvRcvBytes, appcActiveConvUserid=appcActiveConvUserid, appcActiveConvPcidNauName=appcActiveConvPcidNauName, appcActiveConvPcid=appcActiveConvPcid, appcActiveConvModeName=appcActiveConvModeName, appcActiveConvLuwIdName=appcActiveConvLuwIdName)
mibBuilder.exportSymbols("APPC-MIB", appcActiveConvLuwIdInstance=appcActiveConvLuwIdInstance, appcActiveConvLuwIdSequence=appcActiveConvLuwIdSequence, appcActiveConvTpName=appcActiveConvTpName, appcHistConvTable=appcHistConvTable, appcHistConvEntry=appcHistConvEntry, appcHistConvIndex=appcHistConvIndex, appcHistConvEndTime=appcHistConvEndTime, appcHistConvLocLuName=appcHistConvLocLuName, appcHistConvParLuName=appcHistConvParLuName, appcHistConvTpName=appcHistConvTpName, appcHistConvPcidNauName=appcHistConvPcidNauName, appcHistConvPcid=appcHistConvPcid, appcHistConvSenseData=appcHistConvSenseData, appcHistConvLogData=appcHistConvLogData, appcHistConvEndedBy=appcHistConvEndedBy, appcCPIC=appcCPIC, appcCpicAdminTable=appcCpicAdminTable, appcCpicAdminEntry=appcCpicAdminEntry, appcCpicAdminLocLuName=appcCpicAdminLocLuName, appcCpicAdminSymbDestName=appcCpicAdminSymbDestName, appcCpicAdminParLuAlias=appcCpicAdminParLuAlias, appcCpicAdminParLuName=appcCpicAdminParLuName, appcCpicAdminModeName=appcCpicAdminModeName, appcCpicAdminTpNameType=appcCpicAdminTpNameType, appcCpicAdminTpName=appcCpicAdminTpName, appcCpicAdminUserid=appcCpicAdminUserid, appcCpicAdminSecurity=appcCpicAdminSecurity, appcCpicOperTable=appcCpicOperTable, appcCpicOperEntry=appcCpicOperEntry, appcCpicOperLocLuName=appcCpicOperLocLuName, appcCpicOperSymbDestName=appcCpicOperSymbDestName, appcCpicOperParLuAlias=appcCpicOperParLuAlias, appcCpicOperParLuName=appcCpicOperParLuName, appcCpicOperModeName=appcCpicOperModeName, appcCpicOperTpNameType=appcCpicOperTpNameType, appcCpicOperTpName=appcCpicOperTpName, appcCpicOperUserid=appcCpicOperUserid, appcCpicOperSecurity=appcCpicOperSecurity, appcConformance=appcConformance, appcCompliances=appcCompliances, appcGroups=appcGroups)

# Groups
mibBuilder.exportSymbols("APPC-MIB", appcGlobalConfGroup=appcGlobalConfGroup, appcLluConfGroup=appcLluConfGroup, appcParLuConfGroup=appcParLuConfGroup, appcModeConfGroup=appcModeConfGroup, appcTpConfGroup=appcTpConfGroup, appcSessionConfGroup=appcSessionConfGroup, appcControlConfGroup=appcControlConfGroup, appcCnosConfGroup=appcCnosConfGroup, appcCpicConfGroup=appcCpicConfGroup, appcConversationConfGroup=appcConversationConfGroup)

# Compliances
mibBuilder.exportSymbols("APPC-MIB", appcCompliance=appcCompliance)
